/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MALIGNMENT_H_
#define _GB2_MALIGNMENT_H_

#include <core_api/core_api.h>
#include "MAlignmentInfo.h"

namespace GB2 {

class DNAAlphabet;

//todo: define as alphabet property
#define MAlignment_GapChar '-'
#define MAX_ALI_LEN (1000*1000)

class GB2_COREAPI_EXPORT MAlignmentItem {
public:
    MAlignmentItem(){}
    MAlignmentItem(const QString& _name) : name(_name) {}
    MAlignmentItem(const QString& _name, const QByteArray& s) : name(_name), sequence(s) {}

    QString     name;
    QByteArray  sequence;
};

class GB2_COREAPI_EXPORT MAlignment {
public:
    MAlignment(const QString& name = QString(), DNAAlphabet* al = NULL, const QList<MAlignmentItem>& aitems = QList<MAlignmentItem>());
        
    void clear();

    DNAAlphabet*            alphabet;           //alphabet for all sequences in alignment
    QList<MAlignmentItem>   alignedSeqs;
    QVariantMap             info;

    QString getName() const { return MAlignmentInfo::getName( info ); }
    void    setName( const QString& newName ){ MAlignmentInfo::setName( info, newName ); }
    
    bool isEmpty() const {return getLength() == 0;}

    int getLength() const { return alignedSeqs.isEmpty() ? 0 : alignedSeqs.first().sequence.size(); }
    
    int getNumSequences() const {return alignedSeqs.size();}

    char getBase(int seqNum, int pos) const;

    bool isNormalized() const;

    bool hasGaps() const;
    
    void normalizeModel();

    MAlignment subAlignment(int start, int len) const;

    MAlignment& operator+=(const MAlignment& ma);

    inline char charAt(int seqNum, int pos) const;

    int estimateMemorySize() const;
};

char MAlignment::charAt(int seqNum, int pos) const {
    const MAlignmentItem& mai = alignedSeqs[seqNum];
    char c = mai.sequence[pos];
    return c;
}

}//namespace

Q_DECLARE_METATYPE(GB2::MAlignment)

#endif

