/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_STOCKHOLM_FORMAT_H_
#define _GB2_STOCKHOLM_FORMAT_H_

#include <QtCore/QByteArray>

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>

namespace GB2 {

class IOAdapter;
	
class GB2_COREAPI_EXPORT StockholmFormat : public DocumentFormat {
    Q_OBJECT
public:
    static const QByteArray FILE_ANNOTATION_ID;
    static const QByteArray FILE_ANNOTATION_AC;
    static const QByteArray FILE_ANNOTATION_DE;
    static const QByteArray FILE_ANNOTATION_GA;
    static const QByteArray FILE_ANNOTATION_NC;
    static const QByteArray FILE_ANNOTATION_TC;
    static const QByteArray COLUMN_ANNOTATION_SS_CONS;
    static const QByteArray COLUMN_ANNOTATION_RF;
    static const QByteArray UNI_ANNOTATION_MARK;
    
private:
    QString format_name;
	
public:
	StockholmFormat( QObject* obj );

    virtual DocumentFormatId getFormatId() const {
        return BaseDocumentFormats::STOCKHOLM;
    }

    virtual const QString& getFormatName() const {
        return format_name;
    }

    virtual QStringList getSupportedDocumentFileExtensions();

    virtual Document* loadExistingDocument( IOAdapterFactory* io, const QString& url, TaskStateInfo& ti, const QVariantMap& fs );
    virtual Document* loadExistingDocument( IOAdapter* io, TaskStateInfo& ti, const QVariantMap& fs );

    virtual void storeDocument( Document* d, TaskStateInfo& ti, IOAdapterFactory* io = NULL, const QString& newDocURL = QString::null );
    virtual void storeDocument( Document* doc, TaskStateInfo& ti, IOAdapter* io );

    virtual bool isDataFormatSupported( const char* data, int size ) const;

    virtual bool isObjectOpSupported( const Document* d , DocumentFormat::DocObjectOp op, GObjectType t ) const;

    virtual bool checkConstraints( const DocumentFormatConstraints& c ) const;
	
    //exceptions
    struct StockholmBaseException {
        QString msg;
        StockholmBaseException( const QString& str ): msg( str ){}
    };
    struct ReadError : public StockholmBaseException {
        ReadError();
    };
    struct WriteError: public StockholmBaseException {
        WriteError();
    };
    struct BadFileData : public StockholmBaseException {
        BadFileData( const QString& msg ): StockholmBaseException( msg ){}
    };
	
}; // StockholmFormat

} // namespace


#endif //_GB2_STOCKHOLM_FORMAT_H_
