/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "BioStruct3DObject.h"
#include "datatype/DNASequence.h"
#include "GObjectTypes.h"

namespace GB2 { 

BioStruct3DObject::BioStruct3DObject(const BioStruct3D& struct3D, const QString& objectName, const QVariantMap& hintsMap)
: GObject(GObjectTypes::BIOSTRUCTURE_3D, objectName, hintsMap), bioStruct3D(struct3D)
{
}

GObject* BioStruct3DObject::clone() const {
    BioStruct3DObject* cln = new BioStruct3DObject(bioStruct3D,getGObjectName(), getGHintsMap());
    cln->setIndexInfo(getIndexInfo());
    return cln;
}


} //namespace

