/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MEM_BUF_ADAPTER_H_
#define _GB2_MEM_BUF_ADAPTER_H_

#include <core_api/IOAdapter.h>

namespace GB2 {

    class GB2_COREAPI_EXPORT MemBufAdapterFactory: public IOAdapterFactory {
        Q_OBJECT
    public:
        MemBufAdapterFactory(QObject* p = NULL);

        virtual IOAdapter* createIOAdapter();

        virtual IOAdapterId getAdapterId() const {return BaseIOAdapters::MEMORY_BUF;}

        virtual const QString& getAdapterName() const {return name;}

        virtual bool isIOModeSupported(IOAdapterMode m)  const {Q_UNUSED(m); return true;} //files can be read and be written

    protected:
        QString name;
    };

    
    class GB2_COREAPI_EXPORT MemBufAdapter: public IOAdapter {
        Q_OBJECT
    public:
        MemBufAdapter(MemBufAdapterFactory* f, QObject* o = NULL);
        ~MemBufAdapter() {if (isOpen()) close();}

        // ACHTUNG! Here first argument is data buffer, not url
        virtual bool open(const QString& data, IOAdapterMode m);
        // TODO : optimize (prevent copying buffer) by implementing this interface
        // bool open(QByteArray* byteArray, IOAdapterMode m);

        virtual bool isOpen() const {return buffer != NULL;}

        virtual void close();

        virtual qint64 readBlock(char* data, qint64 maxSize);

        virtual qint64 writeBlock(const char* data, qint64 size);

        virtual bool skip(qint64 nBytes);

        virtual qint64 left() const;
        virtual int getProgress() const;

        virtual qint64 bytesRead() const;

        // returns empty string
        virtual QString getUrl() const;

    private:
        QByteArray* byteArray;
        QBuffer* buffer;
    };


}//namespace

#endif // _GB2_MEM_BUF_ADAPTER_H_
