/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "VanDerWaalsSurface.h"
#include "MolecularSurfaceFactoryRegistry.h"

namespace GB2 {

MolecularSurfaceFactoryRegistry::MolecularSurfaceFactoryRegistry( QObject* pOwn /*= 0*/ ) : QObject(pOwn)
{
    registerSurfaceFactory(new VanDerWaalsSurfaceFactory(),QString("VanDerWaals"));
}

MolecularSurfaceFactoryRegistry::~MolecularSurfaceFactoryRegistry()
{
    foreach( MolecularSurfaceFactory* factory, surfMap.values()) {
        delete factory;
    }
}

bool MolecularSurfaceFactoryRegistry::registerSurfaceFactory( MolecularSurfaceFactory* surf, const QString& surfId )
{
    if (surfMap.contains(surfId)){
        return false;
    }
    surfMap.insert(surfId, surf);
    return true;

}

bool MolecularSurfaceFactoryRegistry::hadRegistered( const QString& surfId )
{
    return surfMap.contains(surfId);
}

MolecularSurfaceFactory* MolecularSurfaceFactoryRegistry::getSurfaceFactory( const QString& surfId )
{
    if (surfMap.contains(surfId)) {
        return surfMap.value(surfId);
    } else {
        return NULL;
    }
}

QStringList MolecularSurfaceFactoryRegistry::getSurfNameList()
{
    return surfMap.keys();
}

} // namespace GB2
