/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATION_TABLE_OBJECT_TESTS_H_
#define _GB2_ANNOTATION_TABLE_OBJECT_TESTS_H_

#include "XMLTestUtils.h"
#include <core_api/GObject.h>
#include <QtXml/QDomElement>
#include "DocumentModelTests.h"
#include <core_api/LRegion.h>
#include <gobjects/AnnotationTableObject.h>
namespace GB2 {

class Document;
class LoadDocumentTask;

class GTestAnnotationDataItem: public QObject {
    Q_OBJECT
public:
    GTestAnnotationDataItem(const SharedAnnotationData& ad, QObject* p) : QObject(p), aData(ad){}
    const SharedAnnotationData& getAnnotation() const {return aData;}
private:
    SharedAnnotationData aData;
};


class GTest_CheckNumAnnotations : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CheckNumAnnotations, "check-num-annotations");

    ReportResult report();

private:    
    QString		objContextName;
    int			num;
};

class GTest_FindAnnotationByNum : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_FindAnnotationByNum, "find-annotation-by-number");

    ReportResult report();

    const Annotation *getAnnotation() const {return result;}

    void cleanup();

private:    
    QString		objContextName;
    QString     annotationContextName;
    int			number;
	Annotation  *result;
};

class GTest_FindAnnotationByLocation : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_FindAnnotationByLocation, "find-annotation-by-location");

    ReportResult report();

    const Annotation *getAnnotation() const {return result;}

    void cleanup();

private:    
    QString		objContextName;
    QString     annotationContextName;
    LRegion     location;
    bool        complement;
    Annotation  *result;
};


class GTest_CheckAnnotationLocation : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CheckAnnotationLocation, "check-annotation-location");

    ReportResult report();

private:
    QString		    annCtxName;
	QList<LRegion>  location;
	bool		    complement;
};

class GTest_CheckAnnotationName : public GTest {
    Q_OBJECT
        SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CheckAnnotationName, "check-annotation-name");

    ReportResult report();

private:    
    QString		annCtxName;
    QString		aName;
};


class GTest_CheckAnnotationQualifier : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CheckAnnotationQualifier, "check-annotation-qualifier");

    ReportResult report();

private:    
    QString		annCtxName;
	QString		qName;
	QString		qValue;
};

class GTest_CheckAnnotationsNumInTwoObjects : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CheckAnnotationsNumInTwoObjects, "compare-annotations-num-in-two-objects");

    ReportResult report();
    QString docContextName;
    QString secondDocContextName;
};

class GTest_CheckAnnotationsLocationsInTwoObjects : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CheckAnnotationsLocationsInTwoObjects, "compare-annotations-locations-in-two-objects");

    ReportResult report();
    QString docContextName;
    QString secondDocContextName;
};

class GTest_CheckAnnotationsQualifiersInTwoObjects : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CheckAnnotationsQualifiersInTwoObjects, "compare-annotations-qualifiers-in-two-objects");

    ReportResult report();
    QString docContextName;
    QString secondDocContextName;
};

class GTest_CheckAnnotationsNamesInTwoObjects : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CheckAnnotationsNamesInTwoObjects, "compare-annotations-names-in-two-objects");

    ReportResult report();
    QString docContextName;
    QString secondDocContextName;
};

class AnnotationTableObjectTest {
public:
    static QList<XMLTestFactory*> createTestFactories();
};

}//namespace
#endif
