/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_UINDEX_VIEWER_H_
#define _GB2_UINDEX_VIEWER_H_

#include <core_api/ObjectViewModel.h>
#include <gobjects/UIndexObject.h>

#include "UIndexViewWidgetImpl.h"

namespace GB2 {

class GB2_COREAPI_EXPORT UIndexViewer : public GObjectView {
    Q_OBJECT
public:
    UIndexViewer( const QString& viewName, UIndexObject* obj );
    
    virtual void buildStaticToolbar(QToolBar* tb);
    
    virtual void buildStaticMenu(QMenu* n);
    
    virtual Task* updateViewTask(const QVariantMap& stateData);
    
    UIndexObject* getUindexObject() const { return indexObject; }
    
    const UIndexViewWidgetImpl* getUI() const { return ui; }
    
protected slots:
    void sl_onContextMenuRequested( const QPoint& pos );
    
protected:
    virtual QWidget* createWidget();
    
private:
    static const QString EXPORT_MENU_NAME;
    
    void addExportMenu( QMenu* m );
    
    UIndexObject* indexObject;
    UIndexViewWidgetImpl* ui;

private slots:
    void sl_exportToNewDoc();
    
}; // UIndexViewer

} // GB2

#endif // _GB2_UINDEX_VIEWER_H_
