/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SUBST_MATRIX_H
#define _GB2_SUBST_MATRIX_H

#include <assert.h>
#include <core_api/core_api.h>
#include <core_api/DNAAlphabet.h>


namespace GB2 {

class SubstMatrixFactory;

class GB2_COREAPI_EXPORT SubstMatrix {
	friend class SubstMatrixFactory;
public:
	~SubstMatrix();

	bool create(
			DNAAlphabet* _dnaAlphabet,
			const QByteArray& mtxAlph,
			const float* rawMatrix,
			float defScore
	);

	int getDim() const;
	char getKthSimbol(int k) const;
	DNAAlphabet* getAlphabet() const;

	float getScore(unsigned char a, unsigned char b) const;
	void  setScore(unsigned char a, unsigned char b, float score);

	int	 tr_mapGet(unsigned char ch) const;
	void tr_mapSet(unsigned char ch, int val);
	bool tr_mapEmpty(unsigned char ch) const;

	void dump() const;

private:
	SubstMatrix();
	SubstMatrix(const SubstMatrix& sm);
	SubstMatrix& operator=(const SubstMatrix& sm);

	void setMatrix(float defScore);
	void initTranslationMap(const QByteArray& mtxAlph);
	void initRawMatrix(const QByteArray& mtxAlph, const float* rawMatrix);

	float rawGet(int x, int y) const;
	void  rawSet(int x, int y, float el);

	int dim;
	float* data;
	DNAAlphabet* dnaAlphabet;

	int tr_map[256];
};

} // namespace

#endif
