/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <core_api/IOAdapter.h>
#include <core_api/DocumentModel.h>
#include <util_gui/GUIUtils.h>
#include "SaveDocumentStreamingTask.h"

namespace GB2 {

SaveDocumentStreamingTask::SaveDocumentStreamingTask( Document* d, IOAdapter* i )
: Task(tr("save_document_task_name"), TaskFlags(TaskFlag_None)), lock(NULL), doc(d), io(i) {
    if( NULL == doc ) {
        stateInfo.setError(Translations::badArgument("doc"));
        return;
    }
    if( NULL == io || !io->isOpen() ) {
        stateInfo.setError(Translations::badArgument("IO adapter"));
        return;
    }
    lock = new StateLock( getTaskName() );
    tpm = Progress_Manual;
}

SaveDocumentStreamingTask::~SaveDocumentStreamingTask() {
    assert( NULL == lock );
}

void SaveDocumentStreamingTask::prepare() {
    if( stateInfo.hasErrors() ) {
        return;
    }
    doc->lockState( lock );
}

void SaveDocumentStreamingTask::run() {
    if( stateInfo.hasErrors() ) {
        return;
    }
    DocumentFormat* df = doc->getDocumentFormat();
    df->storeDocument( doc, stateInfo, io );
}

Task::ReportResult SaveDocumentStreamingTask::report() {
    if( NULL != doc ) {
        doc->makeClean();
        doc->unlockState( lock );
    }
    if( NULL != lock ) {
        delete lock;
        lock = NULL;
    }
    return ReportResult_Finished;
}

Document* SaveDocumentStreamingTask::getDocument() const {
    return doc;
}

} // GB2
