/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "TextUtils.h"

#include <assert.h>

namespace GB2 {

static QBitArray getAlphas();
static QBitArray getAlphaNums();
static QBitArray getNums();
static QBitArray getWhites();
static QBitArray getLines();
static QBitArray getBinary();
static QByteArray getUpperCaseMap();
static QByteArray getLowerCaseMap();
static QByteArray getSpaceLine();

const QBitArray TextUtils::ALPHAS = getAlphas();
const QBitArray TextUtils::ALPHA_NUMS = getAlphaNums();
const QBitArray TextUtils::NUMS = getNums();
const QBitArray TextUtils::WHITES = getWhites();
const QBitArray TextUtils::LINE_BREAKS = getLines();
const QBitArray TextUtils::BINARY = getBinary();
const QByteArray TextUtils::UPPER_CASE_MAP = getUpperCaseMap();
const QByteArray TextUtils::LOWER_CASE_MAP = getLowerCaseMap();
const QByteArray TextUtils::SPACE_LINE = getSpaceLine();

//TODO: optimize shared data structs access! -> replace it with arrays with bounds checking in debug

static QBitArray getEmptyBitMap() {
	return QBitArray(256);
}

static QBitArray getBinary() {
	QBitArray res = getEmptyBitMap();
	res.fill(true, 0, 31);
    res &= ~getWhites();
	return res;
}

static QBitArray getAlphaNums() {
	QBitArray res  = getAlphas();
	res|= getNums();
	return res;
}


static QBitArray getAlphas() {
	QBitArray res = getEmptyBitMap();
	res.fill(true, 'A', 'Z'+1);
	res.fill(true, 'a', 'z'+1);
	return res;
}

static QBitArray getNums() {
	QBitArray res = getEmptyBitMap();
	res.fill(true, '0', '9'+1);
	return res;
}

static QBitArray getWhites() {
    //'\t', '\n', '\v', '\f', '\r', and ' '
	QBitArray res = getEmptyBitMap();
    res['\t']=res['\n']=res['\v']=res['\f']=res['\r']=res[' ']=true;
	return res;
}

QBitArray getLines() {
	QBitArray res = getEmptyBitMap();
	res['\r'] = res['\n'] = true;
	return res;
}

QBitArray TextUtils::createBitMap(char c1) {
	QBitArray res = getEmptyBitMap();
	res[c1] = true;
	return res;
}

QByteArray TextUtils::createMap(const QBitArray& bits, char defaultChar) {
	assert(bits.size() == 256);
	QByteArray res(256, 0);
	for(int i=0;i<256; i++) {
		res[i] = bits[i] ? (char)i : defaultChar;
	}
	return res;
}

static QByteArray getUpperCaseMap() {
	QByteArray b(256, 0);
	for(int i=0;i<b.size();i++) {
		char c = (char)i;
		if (c >= 'a' && c<='z') {
			c-='a'-'A';
		}
		b[i] = c;
	}
	return b;
}

static QByteArray getLowerCaseMap() {
	QByteArray b(256, 0);
	for(int i=0;i<b.size();i++) {
		char c = (char)i;
		if (c >= 'A' && c<='Z') {
			c+='a'-'A';
		}
		b[i] = c;
	}
	return b;
}


static QByteArray getSpaceLine() {
	QByteArray res(4096, ' ');
	res[4096]='\0';
	return res;
}

QString TextUtils::variate(const QString& prefix, const QString& sep, const QSet<QString>& filter, bool mustHaveSuffix, int startSeed) {
    int seed = startSeed;
    QString res = prefix;
    if (!mustHaveSuffix && !filter.contains(res) && !res.isEmpty()) {
        return res;
    }
    do {
        res = prefix + sep + QString::number(seed++);
    } while (filter.contains(res));
    return res;
}

}//namespace
