/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_IO_TASK_H_
#define _GB2_WORKFLOW_IO_TASK_H_

#include <core_api/Task.h>
#include <workflow/WorkflowModel.h>
#include <workflow/Schema.h>

#include <QtCore/QPointer>

class QDomDocument;

namespace GB2 {
using namespace Workflow;

class GB2_COREAPI_EXPORT SaveWorkflowTask : public Task {
    Q_OBJECT
public:
    SaveWorkflowTask(Schema*, const Metadata& meta);
    virtual void run();
    //Schema* getSchema() const {return schema;}
protected:
    //Schema* schema;
    QByteArray rawData;
    QString url;
};

class GB2_COREAPI_EXPORT LoadWorkflowTask : public Task {
    Q_OBJECT
public:
    LoadWorkflowTask(Schema* schema, Metadata* meta, const QString& url);
    virtual void run();
    Task::ReportResult report();
    Schema* getSchema() const {return schema;}
    QString getUrl() const {return url;}
    QMap<ActorId, ActorId> getRemap() const {return remapping;}
protected:
    const QString url;
    Schema* schema;
    Metadata* meta;
    QDomDocument* xml;
    QMap<ActorId, ActorId> remapping;
};

} //namespace
#endif
