/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "WorkflowSettings.h"
//#include "WorkflowViewController.h"

#include <core_api/AppContext.h>
#include <core_api/Settings.h>

#include <QtCore/QSettings>
#include <QtGui/QApplication>
#include <QtGui/QStyle>
#include <QtGui/QStyleFactory>

namespace GB2 {

#define GRID_STATE SETTINGS + "showGrid"
#define SNAP_STATE SETTINGS + "snap2rid"
#define LOCK_STATE SETTINGS + "monitorRun"
#define FAIL_STATE SETTINGS + "failFast"
#define STYLE      SETTINGS + "style"
#define FONT       SETTINGS + "font"

Watcher* const WorkflowSettings::watcher = new Watcher;

bool WorkflowSettings::showGrid() {
    return AppContext::getSettings()->getValue(GRID_STATE, true).toBool();
}

void WorkflowSettings::setShowGrid( bool v ) {
    if (showGrid() != v) {
        AppContext::getSettings()->setValue(GRID_STATE, v);
        emit watcher->changed();
    }
}

bool WorkflowSettings::snap2Grid() {
    return AppContext::getSettings()->getValue(SNAP_STATE, true).toBool();
}

void WorkflowSettings::setSnap2Grid( bool v ) {
    AppContext::getSettings()->setValue(SNAP_STATE, v);
}

bool WorkflowSettings::monitorRun() {
    return AppContext::getSettings()->getValue(LOCK_STATE, true).toBool();
}

void WorkflowSettings::setMonitorRun( bool v ) {
    AppContext::getSettings()->setValue(LOCK_STATE, v);
}

bool WorkflowSettings::failFast() {
    return AppContext::getSettings()->getValue(FAIL_STATE, true).toBool();
}

void WorkflowSettings::setFailFast( bool v ) {
    AppContext::getSettings()->setValue(FAIL_STATE, v);
}

QString WorkflowSettings::defaultStyle()
{
    return AppContext::getSettings()->getValue(STYLE, true).toString();
}

void WorkflowSettings::setDefaultStyle(const QString& s)
{   
    AppContext::getSettings()->setValue(STYLE, s);
}

QFont WorkflowSettings::defaultFont()
{
    return AppContext::getSettings()->getValue(FONT, true).value<QFont>();
}

void WorkflowSettings::setDefaultFont(const QFont& f)
{   
    if (defaultFont() != f) {
        AppContext::getSettings()->setValue(FONT, qVariantFromValue(f));
        emit watcher->changed();
    }
}

}//namespace
