/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CollocationsSearchAlgorithm.h"

namespace GB2 {

void CollocationsAlgorithm::find(const QList<CollocationsAlgorithmItem>& items, TaskStateInfo& si, 
		CollocationsAlgorithmListener* l, const CollocationsAlgorithmSettings& cfg) 
{
	cfg.st == NormalSearch ? findN(items, si, l, cfg.searchRegion, cfg.distance) : findP(items, si, l, cfg.searchRegion, cfg.distance);
}

void CollocationsAlgorithm::findN(const QList<CollocationsAlgorithmItem>& items, TaskStateInfo& si, 
                                 CollocationsAlgorithmListener* l, const LRegion& searchRegion, int distance) 
{
    //todo: progress

    int i=searchRegion.endPos();
    foreach(const CollocationsAlgorithmItem& item, items) {
        foreach(const LRegion& r, item.regions) {
            assert(searchRegion.contains(r));
            i = qMin(i, r.startPos);
        }
    }
    if (i == searchRegion.endPos()) {
        return;
    }

    LRegion prevResult;
    do {
        LRegion res;
        LRegion currentRegion(i, qMin(i+distance, searchRegion.endPos()) - i);
        bool onResult = true;
        int nextI = currentRegion.endPos();
        foreach(const CollocationsAlgorithmItem& item, items) {
            bool foundItem = false;
            int nextItemStart =  currentRegion.endPos();
            foreach(const LRegion& r, item.regions) {
                if (r.startPos > currentRegion.startPos) {
                      nextItemStart = qMin(nextItemStart, r.startPos);
                }
                if (onResult && currentRegion.contains(r)) {
                    foundItem = true;
                    res = res.len == 0 ? r : LRegion::containingRegion(res, r);
                }
            }
            nextI = qMin(nextI, nextItemStart);
            onResult = onResult && foundItem;
        }
        if (onResult && res.startPos == i) {
            assert(res.len > 0);
            if (prevResult.contains(res)) {
                //nothing to do;
            } else {
                assert(!res.contains(prevResult) || prevResult.len == 0);
                assert(prevResult.endPos() < res.endPos());
                l->onResult(res);
                prevResult = res;
            }
        } 
        assert(nextI > i);
        i = nextI;
        si.progress = int(100*float(i - searchRegion.startPos)/searchRegion.len);
    } while (i + distance < searchRegion.endPos());
}

void averagingRes(LRegion& res, const LRegion& min, const LRegion& max, int distance, const LRegion& searchRegion)
{
	//?
	if (!min.intersects(max)) {
		res.startPos = min.endPos()-1;
		res.len = max.startPos - min.endPos() + 2; 
	}
	else {
		res.startPos = max.startPos;
		res.len = min.endPos() - max.startPos;
	}
	int tmp = distance - res.len;
	res.startPos -= tmp*min.len/(max.len+min.len);
	if (res.startPos<0) res.startPos = 0;
	res.len = distance;
	if (res.endPos() > searchRegion.endPos()) {
		res.startPos -= (res.endPos()-searchRegion.endPos());
		//res.len = (searchRegion.endPos() - res.startPos);
	}
	if (res.endPos() > max.endPos()) {
		res.startPos -= (res.endPos()-max.endPos());
	}
	if (res.startPos<0) res.startPos = 0;
}


void CollocationsAlgorithm::findP(const QList<CollocationsAlgorithmItem>& items, TaskStateInfo& si, 
                                 CollocationsAlgorithmListener* l, const LRegion& searchRegion, int distance) 
{
	//printf("partial_search!\n");

    int i = searchRegion.endPos();
    foreach(const CollocationsAlgorithmItem& item, items) {
        foreach(const LRegion& r, item.regions) {
            assert(searchRegion.contains(r));
			if (i > r.endPos()-1) {
				i = r.endPos()-1; 
			}
        }
    }
    if (i == searchRegion.endPos()) {
        return;
    }
    LRegion prevResult;
	LRegion prevMax;
    do {
		LRegion res;
        LRegion currentRegion(i, qMin(i+distance, searchRegion.endPos()) - i);
		LRegion min, max;
		min.startPos = searchRegion.endPos() - 1;
		max.startPos = 0;
        bool onResult = true;
        int nextI = currentRegion.endPos();
        foreach(const CollocationsAlgorithmItem& item, items) {
            bool foundItem = false;
            int nextItemEnd =  searchRegion.endPos();
            foreach(const LRegion& r, item.regions) {
				if (r.endPos() <= searchRegion.endPos() && r.endPos()-1 > currentRegion.startPos
														&& nextItemEnd > r.endPos()-1) {
						nextItemEnd = r.endPos()-1;
                }
				if (onResult && currentRegion.intersects(r)) {
                    foundItem = true;
					if (r.endPos() < min.endPos()) min = r;
					if (max < r) max = r;
					res = res.len == 0 ? r : LRegion::containingRegion(res, r);
                }
            }
            nextI = qMin(nextI, nextItemEnd);
            onResult = onResult && foundItem;
        }
		//error mb use list of prev included anno?
		//
        if (onResult && 
			prevMax != max
			//!prevResult.contains(res)
			) {
			prevResult = res;
			prevMax = max;


			if (res.len > distance) {
				//function res averaging
				//void averagingRes(LRegion& res, const LRegion& min, const LRegion& max, int distance)
/*				if (!min.intersects(max)) {
					res.startPos = min.endPos()-1;
					res.len = max.startPos - min.endPos() + 2; 

					int tmp = distance - res.len;
					res.startPos -= tmp*min.len/(max.len+min.len);
					if (res.startPos<0) res.startPos = 0;
					res.len = distance;
					if (res.endPos() > searchRegion.endPos()) res.len = (searchRegion.endPos() - res.startPos);
				}
				else {
					res.startPos = max.startPos;
					res.len = min.endPos() - max.startPos;

					int tmp = distance - res.len;
					res.startPos -= tmp*min.len/(max.len+min.len);
					if (res.startPos<0) res.startPos = 0;
					res.len = distance;
					if (res.endPos() > searchRegion.endPos()) res.len = (searchRegion.endPos() - res.startPos);

				}*/
				averagingRes(res, min, max, distance, searchRegion);
			}

            assert(res.len > 0);
            l->onResult(res);
        } 
        assert(nextI > i);
        i = nextI;
        si.progress = int(100*float(i - searchRegion.startPos)/searchRegion.len);
    } while (i < searchRegion.endPos());
}

}//namespace
