/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ExportMSA2SequenceDialog.h"

#include <core_api/AppContext.h>
#include <core_api/Settings.h>
#include <core_api/DocumentFormats.h>
#include <util_gui/DialogUtils.h>

#include <QtGui/QMessageBox>
#include <QtGui/QFileDialog>

#define SETTINGS_ROOT QString("dna_export/")

namespace GB2 {

ExportMSA2SequenceDialog::ExportMSA2SequenceDialog() {
    setupUi(this);    

    connect(fileButton, SIGNAL(clicked()), SLOT(sl_selectFile()));
}

void ExportMSA2SequenceDialog::sl_selectFile() {
    QString filter = DialogUtils::prepareDocumentsFileFilter(BaseDocumentFormats::PLAIN_FASTA, false);
    LastOpenDirHelper lod;
    lod.url = QFileDialog::getSaveFileName(NULL, tr("Select file to export"), lod, filter);
    if (lod.url.isEmpty()) {
        return;
    }
    fileNameEdit->setText(lod.url);
}

void ExportMSA2SequenceDialog::accept() {
    if (fileNameEdit->text().isEmpty()) {
        QMessageBox::critical(this, tr("Error"), tr("File name is empty!"));
        return;
    }
    
    url = fileNameEdit->text();
    trimGaps = trimGapsRB->isChecked();

    QDialog::accept();
}


}//namespace
