/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GRAPHPACK_DEVIATION_H_
#define _GB2_GRAPHPACK_DEVIATION_H_

#include "DNAGraphPackPlugin.h"

#include <util_ov_annotated_dna/GSequenceGraphView.h>

#include <QtGui/QAction>
#include <QtCore/QList>
#include <QtCore/QBitArray>
#include <QtCore/QPair>

namespace GB2 {

class DeviationGraphFactory : public GSequenceGraphFactory {
	Q_OBJECT
public:
	enum GDeviationType { GC, AT };
	DeviationGraphFactory(GDeviationType t, QObject* p);
	virtual QList<GSequenceGraphData*> createGraphs(GSequenceGraphView* v);
    virtual GSequenceGraphDrawer* getDrawer(GSequenceGraphView* v);
	virtual bool isEnabled(DNASequenceObject* o) const;
private:
	QPair<char, char> devPair;
};

class DeviationGraphAlgorithm : public GSequenceGraphAlgorithm {
public:
	DeviationGraphAlgorithm(const QPair<char, char>& _p);
    virtual ~DeviationGraphAlgorithm() {}

	virtual void calculate(QVector<float>& res, DNASequenceObject* o, const LRegion& r, const GSequenceGraphWindowData* d);

private:
	void windowStrategyWithoutMemorize(QVector<float>& res, const QByteArray& seq, int startPos, const GSequenceGraphWindowData* d, int nSteps);
	void sequenceStrategyWithMemorize(QVector<float>& res, const QByteArray& seq, const LRegion& vr, const GSequenceGraphWindowData* d);
	QPair<int, int> matchOnStep(const QByteArray& seq, int begin, int end);
	QPair<char, char> p;
};

} // namespace
#endif
