/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DNAStatPlugin.h"
#include "DNAStatMSAProfileDialog.h"

#include <core_api/AppContext.h>

#include <util_gui/GUIUtils.h>
#include <util_ov_msaedit/MSAEditor.h>
#include <util_ov_msaedit/MSAEditorFactory.h>

#include <QtGui/QMenu>
#include <QtCore/QMap>
#include <QtGui/QAction>

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    if (AppContext::getMainWindow()) {
        DNAStatPlugin* plug = new DNAStatPlugin();
        return plug;
    }
    return NULL;
}

DNAStatPlugin::DNAStatPlugin() : Plugin(tr("DNA Statistics"), tr("Provides statistical reports for sequences and alignments"))
{
    viewCtx = new DNAStatMSAEditorContext(this);
    viewCtx->init();
}


DNAStatMSAEditorContext::DNAStatMSAEditorContext(QObject* p) : 
GObjectViewWindowContext(p, MSAEditorFactory::ID) {}

void DNAStatMSAEditorContext::initViewContext(GObjectView* v) {
    GObjectViewAction* profileAction = new GObjectViewAction(this, v, tr("Generate grid profile"));
    connect(profileAction, SIGNAL(triggered()), SLOT(sl_showMSAProfileDialog()));
    addViewAction(profileAction);
}

void DNAStatMSAEditorContext::buildMenu(GObjectView* v, QMenu* m) {
    QList<GObjectViewAction *> actions = getViewActions(v);
    QMenu* statMenu = GUIUtils::findSubMenu(m, MSAE_MENU_STATISTICS);
    assert(statMenu!=NULL);
    foreach(GObjectViewAction* a, actions) {
        statMenu->addAction(a);
    }    
}

void DNAStatMSAEditorContext::sl_showMSAProfileDialog() {
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(sender());
    MSAEditor* msaEd = qobject_cast<MSAEditor*>(viewAction->getObjectView());
    DNAStatMSAProfileDialog d(msaEd->getWidget(), msaEd);
    d.exec();
}


}//namespace

