/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_SW_ALGORITHM_TESTS_H_
#define _GB2_SW_ALHORITHM_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GObject.h>
#include <QtXml/QDomElement>
#include <test_framework/xmltest/DocumentModelTests.h>
#include <core_api/LRegion.h>
#include <gobjects/AnnotationTableObject.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>

#include <SWAlgorithmTask.h>
#include <PairAlignSequences.h>
#include <datatype/DNASequence.h>

#include <qbytearray.h>


namespace GB2 {

	struct PairSequences{
		QByteArray searchSeq;
		LRegion sInterval;
		QByteArray patterSeq;
		LRegion pInterval;
		int score;
	};

	class GTest_SWAlgorithm : public GTest {
		Q_OBJECT
	public:
		SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_SWAlgorithm, "plugin_sw-algorithm");

		void prepare();
		Task::ReportResult report();
	private:
		bool parseExpected_res();
		bool toInt(QString & str, int & num);

		QByteArray patternSeq;
		QByteArray searchSeq;

		QString patternSeqDocName;
		QString searchSeqDocName;
		QString expected_res;

		QString pathToSubst;
		int gapOpen;		
		int gapExtension;
		float percentOfScore;
		int countOfResults;

		QString resultDocContextName;				
		QVector<PairSequences> expectedRes;

		SWAlgorithmTask * swAlgorithmTask;
	};

} //namespace
#endif

