/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_ALG_IMPL_H_
#define _GB2_SMITH_WATERMAN_ALG_IMPL_H_

#include <util_smith_waterman/SmithWatermanTaskFactory.h>
#include <util_smith_waterman/SmithWatermanSettings.h>
#include <util_tasks/SequenceWalkerTask.h>
#include <core_api/Task.h>

#include "SWAlgorithmTask.h"

namespace GB2 {

	class SWTaskFactory: public SmithWatermanTaskFactory {
	public:
		SWTaskFactory(AlgType _algType);
		virtual ~SWTaskFactory();
		virtual Task* getTaskInstance(const SmithWatermanSettings& config,
			const QString& taskName) const;
		virtual bool hasAbvancedSettings() const;
		virtual void execAbvancedDialog();

	private:
		bool isValidParameters(const SmithWatermanSettings& sWatermanConfig, 
			SequenceWalkerSubtask* t) const;
		AlgType algType;

	};

} // namespace

#endif
