/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifdef SW2_BUILD_WITH_CUDA

#include "SmithWatermanAlgorithmCUDA.h"
#include "sw_kernel_cpp.h"
#include "PairAlignSequences.h"
#include "CList.h"


#include <core_api/Log.h>

#include <iostream>

using namespace std;

namespace GB2 {
	
	static LogCategory log(ULOG_CAT_SW);

	void SmithWatermanAlgorithmCUDA::launch(SubstMatrix const * _substitutionMatrix, QByteArray const & _patternSeq, QByteArray const & _searchSeq, int _gapOpen, int _gapExtension, int _minScore) {
	
		cout <<"START SmithWatermanAlgorithmCUDA::launch" <<endl;		

		int qLen = _patternSeq.size();
		int subLen = _substitutionMatrix->getAlphabet()->getNumAlphabetChars();

		int profLen = subLen * (qLen + 1) * 'Z';

		ScoreType *  queryProfile = new ScoreType[profLen];

		for (int i = 0; i < profLen; i++) {
			queryProfile[i] = 0;
		}

		for (int i = 0; i < subLen; i++) {
			for (int j = 0; j < qLen; j++) {
				char ch = _substitutionMatrix->getAlphabet()->getAlphabetChars()[i];
				queryProfile[ch * qLen + j] = 
					_substitutionMatrix->getScore(ch, _patternSeq.at(j));			
			}		
		}

		CList<resType>* pResults = NULL;		

		sw_kernel_cpp sw;

		pResults = sw.launch(_searchSeq.constData(), _searchSeq.size(), queryProfile, profLen, qLen, (-1)*_gapOpen, (-1)*_gapExtension, _minScore);	

// Collect results
		PairAlignSequences tmp;
		resType res;
		pResults->SetFrontPos();
		for (int i = 0; i < pResults->GetSize(); i++ ) {

			res = pResults->GetNext();

			tmp.score = res.score;

			tmp.intervalSeq1.startPos = res.reg.startPos;

			tmp.intervalSeq1.len = res.reg.len;

			pairAlignmentStrings.append(tmp);	

		}

		delete[] queryProfile;
		delete pResults;	

		printf("end cuda!!!!!!!!!!!!");

		
		cout <<"FINISH SmithWatermanAlgorithmCUDA::launch" <<endl;
	}

} //namespase

#endif //SW2_BUILD_WITH_CUDA

