/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_SAMPLES_H_
#define _GB2_WORKFLOW_SAMPLES_H_

#include "GlassView.h"
#include <workflow/Descriptor.h>
#include <core_api/Task.h>

#include <QtGui/QAction>
#include <QtGui/QToolBox>
#include <QtGui/QButtonGroup>
#include <QtGui/QTreeWidget>

#include <QtXml/qdom.h>

namespace GB2 {
class WorkflowView;
class WorkflowScene;

class Sample {
public:
    //Sample(const QString& url);
    Descriptor d;
    QIcon ico;
    QString data;
    QDomDocument content;
};

class SampleCategory {
public:
    SampleCategory(const QString& dir, const QString& name) : d(dir, name, ""){}
    Descriptor d;
    QList<Sample> items;
};

class LoadSamplesTask : public Task {
    Q_OBJECT
public:
    LoadSamplesTask(const QStringList&);
    void run();
    ReportResult report();
private:
    void scanDir(const QString&);
    QStringList dirs;
    QList<SampleCategory> result;
};

class SampleRegistry {
public:
    static Task* init(const QStringList&);
    static QList<SampleCategory> getCategories() {return data;}
private:
    static QList<SampleCategory> data;
    friend class LoadSamplesTask;
};

class SamplePane : public GlassPane {
    Q_OBJECT
public:
    SamplePane();
    virtual void paint(QPainter*);
    virtual bool eventFilter(QObject*, QEvent* e) {
        this->event(e);
        return item != NULL;
    }

public slots:
    void test();
    void setItem(QTreeWidgetItem*);
signals:
    void itemActivated(QTreeWidgetItem * item);
    void cancel();
protected:
    virtual void mouseDoubleClickEvent ( QMouseEvent * event );
    virtual void keyPressEvent ( QKeyEvent * event );
    //    virtual void mousePressEvent ( QMouseEvent * event );
    //virtual void mouseReleaseEvent ( QMouseEvent * event );
private:
    QTextDocument*      m_document;
    QTreeWidgetItem*    item;
};


class SamplesWidget : public QTreeWidget {
    Q_OBJECT
public:
    static const QString MIME_TYPE;

    SamplesWidget(QWidget *parent = 0);
//     QList<Descriptor> getCategories() const;
//     QList<Descriptor> getItems(const Descriptor& cat) const;
//     QMenu* createMenu(const QString& name);
// 
//     QVariant saveState() const;
//     void restoreState(const QVariant&);
// 
//     public slots:
//         void resetSelection();
// 
// signals:
//         void processSelected(Workflow::ActorPrototype*);
// 
// protected:
//     void contextMenuEvent(QContextMenuEvent *e);
public slots:
    void cancelItem();
protected:
    void resizeEvent(QResizeEvent *e) {
        QTreeWidget::resizeEvent(e);
        doItemsLayout();
    }

private slots:
    void handleTreeItem(QTreeWidgetItem * item);
    void activateItem(QTreeWidgetItem * item);
    
signals:
    void setupGlass(GlassPane*);
    void sampleSelected(const QString&);
private:
    void addCategory(const SampleCategory& cat);

    SamplePane* glass;
};

}//namespace

//Q_DECLARE_METATYPE(QAction *)

#endif
