/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_W_SETTINGS_GUI_CONTROLLER_H_
#define _GB2_W_SETTINGS_GUI_CONTROLLER_H_

#include <ui/ui_WorkflowSettingsWidget.h>

#include <core_api/AppSettingsGUI.h>

namespace GB2 {

#define WorkflowSettingsPageId QString("wds")

class WorkflowSettingsPageController : public AppSettingsGUIPageController {
    Q_OBJECT
public:
    WorkflowSettingsPageController(QObject* p = NULL);

    virtual AppSettingsGUIPageState* getSavedState();

    virtual void saveState(AppSettingsGUIPageState* s);

    virtual AppSettingsGUIPageWidget* createWidget(AppSettingsGUIPageState* data);
};


class WorkflowSettingsPageState : public AppSettingsGUIPageState {
    Q_OBJECT
public:
    bool showGrid;
    bool snap2grid;
    bool lockRun;
    bool failFast;
    QString style;
    QFont font;
};


class WorkflowSettingsPageWidget: public AppSettingsGUIPageWidget, public Ui_WorkflowSettingsWidget {
    Q_OBJECT
public:
    WorkflowSettingsPageWidget(WorkflowSettingsPageController* ctrl);

    virtual void setState(AppSettingsGUIPageState* state);

    virtual AppSettingsGUIPageState* getState(QString& err) const;
};

}//namespace

#endif
