/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_HMMSEARCH_WORKER_H_
#define _GB2_HMMSEARCH_WORKER_H_

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>

#include "uhmmsearch.h"

namespace GB2 {

namespace LocalWorkflow {

class HMMSearchPrompter : public PrompterBase<HMMSearchPrompter> {
    Q_OBJECT
public:
    HMMSearchPrompter(Actor* p = 0) : PrompterBase<HMMSearchPrompter>(p) {}
protected:
    QString composeRichDoc();
};

class HMMSearchWorker : public BaseWorker {
    Q_OBJECT
public:
    HMMSearchWorker(Actor* a);
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() {}
private slots:
    void sl_taskFinished(Task*);

protected:
    IntegralBus *hmmPort, *seqPort, *output;
    QString resultName;
    UHMMSearchSettings cfg;
    QList<plan7_s*> hmms;
}; 

class HMMSearchWorkerFactory : public DomainFactory {
public:
    static const QString ACTOR;
    static void init();
    HMMSearchWorkerFactory() : DomainFactory(ACTOR) {}
    virtual Worker* createWorker(Actor* a) {return new HMMSearchWorker(a);}
};

}//Workflow namespace
}//GB2 namespace

#endif
