/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_UHMMER3_PLUGIN_H_
#define _GB2_UHMMER3_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/AppContext.h>
#include <gobjects/DNASequenceObject.h>

namespace GB2 {

class UHMM3Plugin : public Plugin {
    Q_OBJECT
public:
    UHMM3Plugin();
    ~UHMM3Plugin();
    
private:
    DNASequenceObject * getDnaSequenceObject() const;
    
private slots:
    void sl_buildProfile();
    void sl_searchHMMSignals();
    void sl_phmmerSearch();
    
}; // uHMM3Plugin

} // GB2

#endif // _GB2_UHMMER3_PLUGIN_H_
