/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _PRIMER3_DIALOG_CONTROLLER_H_
#define _PRIMER3_DIALOG_CONTROLLER_H_

#include "ui/ui_Primer3Dialog.h"
#include "Primer3Task.h"
#include <QtGui/QDialog>
#include <datatype/AnnotationData.h>
#include <util_gui/CreateAnnotationWidgetController.h>

namespace GB2 {

class ADVSequenceObjectContext;
class DNASequenceObject;
class Primer3Plugin;

class Primer3DialogController : public QDialog, public Ui_Primer3Dialog {
    Q_OBJECT

public:
    Primer3DialogController(ADVSequenceObjectContext* ctx);    
    ~Primer3DialogController();    
    primer_args *pa;
    seq_args *sa;
    primers_t primers;
    
    public slots:
        virtual void reject();

    private slots:
        void sl_sbRangeStartChanged(int val);
        void sl_sbRangeEndChanged(int val);
        void sl_pbPickClicked();
        void sl_pbResetClicked();   
        void sl_pbSelectionRange();
        void sl_pbSequenceRange();

private:

    ADVSequenceObjectContext* ctx;
    CreateAnnotationModel acm;
    CreateAnnotationWidgetController* ac;

    int seqLen;
    LRegion initialSelection;

    void connectGUI();
    void addAnnotationWidget();

    bool readForm();
    char *QStringToChar(QString in);
    bool QStringToChar(QLineEdit *in, char *out);
    bool QStringToInt(QLineEdit *in, int *out);
    bool QStringToDouble(QLineEdit *in, double *out);
    bool QStringToShortAlign(QLineEdit *in, short *out);
};

} //namespace

#endif //_PRIMER3_DIALOG_CONTROLLER_H_