/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Primer3Tests.h"
#include "primer3.h"

namespace GB2{

#define DBFILEPATH_ATTR "dbfile"
#define PROTEIN_ATTR "is_protein"
#define EXPECTED_LOAD_ATTR "is_load_expected"
#define CREATION_DATE_ATTR "creation_date"
#define CONTEXT_NAME_ATTR "index"
#define CHECK_DATE_ATTR "check_date"
/*
PRIMER_INTERNAL_OLIGO_MISHYB_LIBRARY
PRIMER_MISPRIMING_LIBRARY
PRIMER_SEQUENCE_QUALITY
*/

static const QString extensionsToCheck[14] = {".nhr",".nnd",".nni",".nsd",".nsi",".nsq", ".nin",
    ".phr",".pnd",".pni",".psd",".psi",".psq", ".pin"};

void GTest_Primer3::init(XMLTestFormat *tf, const QDomElement& el){
    Q_UNUSED(tf);
    int size_pa = sizeof(*pa);
    pa = (primer_args *)pr_safe_malloc(size_pa);
    int size_sa = sizeof(*sa);
    sa = (seq_args *)pr_safe_malloc(size_sa); 
    memset(&sa->error, 0, sizeof(sa->error));
    memset(&pa->glob_err, 0, sizeof(pa->glob_err));
    memset(sa, 0, size_sa);  

    pr_set_default_global_args(pa);
    sa->start_codon_pos = PR_DEFAULT_START_CODON_POS;
    sa->incl_l = -1; /* Indicates logical NULL. */

    QString buf;
    QString *task_tmp = NULL;
    int n_quality=0;
    QDomNodeList inputParameters = el.elementsByTagName("plugin_primer_3_in");
    for(int i=0;i<inputParameters.size(); i++) {
        QDomNode n = inputParameters.item(i);
        assert(n.isElement());
        if (!n.isElement()) {
            continue;
        }
        QDomElement elInput = n.toElement();
//1
    buf = elInput.attribute("PRIMER_SEQUENCE_ID");
    if (!buf.isEmpty()){
        sa->sequence_name=stringToChar(buf);
    }
//2
    buf = elInput.attribute("SEQUENCE");
    if (!buf.isEmpty()){
        sa->sequence=stringToChar(buf);
    }
//3
    buf = elInput.attribute("TARGET");
    if (!buf.isEmpty()){
        int i=0;
        foreach(QString str,buf.split(' ',QString::SkipEmptyParts)){
            sa->tar[i][0]=str.split(',')[0].toInt();
            sa->tar[i][1]=str.split(',')[1].toInt();
            i++;
        }
        sa->num_targets=i;
    }
//4
    buf = elInput.attribute("PRIMER_OPT_SIZE");
    if (!buf.isEmpty()){
        pa->primer_opt_size=buf.toInt();
    }
//5
    buf = elInput.attribute("PRIMER_MIN_SIZE");
    if (!buf.isEmpty()){
        pa->primer_min_size=buf.toInt();
    }
//6
    buf = elInput.attribute("PRIMER_MAX_SIZE");
    if (!buf.isEmpty()){
        pa->primer_max_size=buf.toInt();
    }
//7
    buf = elInput.attribute("PRIMER_NUM_NS_ACCEPTED");
    if (!buf.isEmpty()){
        pa->num_ns_accepted=buf.toInt();
    }
//8
    buf = elInput.attribute("PRIMER_PRODUCT_SIZE_RANGE");
    if (!buf.isEmpty()){
        int i=0;
        foreach(QString str,buf.split(' ',QString::SkipEmptyParts)){
            pa->pr_min[i]=str.split('-')[0].toInt();
            pa->pr_max[i]=str.split('-')[1].toInt();
            i++;
        }
        pa->num_intervals=i;
    }
//9
    buf = elInput.attribute("PRIMER_FILE_FLAG");
    if (!buf.isEmpty()){
        pa->file_flag=buf.toInt();
    }
//10
    buf = elInput.attribute("PRIMER_PICK_INTERNAL_OLIGO");
    if (!buf.isEmpty()){
        int pick_internal_oligo = buf.toInt();
        if((pick_internal_oligo == 1 || pick_internal_oligo == 0) &&
            (pa->primer_task == pick_left_only || 
            pa->primer_task == pick_right_only ||
            pa->primer_task == pick_hyb_probe_only)) 
            stateInfo.setError(GTest::tr("Contradiction in primer_task definition"));//??? may be remove from this place
        else if(pick_internal_oligo == 1) 
            pa->primer_task = pick_pcr_primers_and_hyb_probe;
        else if(pick_internal_oligo == 0)pa->primer_task = pick_pcr_primers;
    }
//11
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_EXCLUDED_REGION");
    if (!buf.isEmpty()){
        int i=0;
        foreach(QString str,buf.split(' ',QString::SkipEmptyParts)){
            sa->excl_internal[i][0]=str.split(',')[0].toInt();
            sa->excl_internal[i][1]=str.split(',')[1].toInt();
            i++;
        }
        sa->num_internal_excl=i;
    }
//12
    buf = elInput.attribute("PRIMER_EXPLAIN_FLAG");
    if (!buf.isEmpty()){
        pa->explain_flag=buf.toInt();
    }
//13
    buf = elInput.attribute("PRIMER_FIRST_BASE_INDEX");
    if (!buf.isEmpty()){
        pa->first_base_index=buf.toInt();
    }
//14
    buf = elInput.attribute("PRIMER_MAX_POLY_X");
    if (!buf.isEmpty()){
        pa->max_poly_x=buf.toInt();
    }
//15
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MAX_POLY_X");
    if (!buf.isEmpty()){
        pa->io_max_poly_x=buf.toInt();
    }
//16
    buf = elInput.attribute("PRIMER_MIN_TM");
    if (!buf.isEmpty()){
        pa->min_tm=buf.toDouble();
    }
//17
    buf = elInput.attribute("PRIMER_MAX_TM");
    if (!buf.isEmpty()){
        pa->max_tm=buf.toDouble();
    }
//18
    buf = elInput.attribute("PRIMER_MAX_GC");
    if (!buf.isEmpty()){
        pa->max_gc=buf.toDouble();
    }
//19
    buf = elInput.attribute("PRIMER_MIN_GC");
    if (!buf.isEmpty()){
        pa->min_gc=buf.toDouble();
    }
//20
    buf = elInput.attribute("PRIMER_SELF_END");
    if (!buf.isEmpty()){
        pa->self_end=(short)(buf.toDouble()*100);
    }
//21
    buf = elInput.attribute("PRIMER_SELF_ANY");
    if (!buf.isEmpty()){
        pa->self_any=(short)(buf.toDouble()*100);
    }
//22???
    buf = elInput.attribute("INCLUDED_REGION");
    if (!buf.isEmpty()){
        sa->incl_s=buf.split(',')[0].toInt();
        sa->incl_l=buf.split(',')[1].toInt();//??? may be wrong
    }
//23
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_OPT_SIZE");
    if (!buf.isEmpty()){
        pa->io_primer_opt_size=buf.toInt();
    }
//24
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MIN_SIZE");
    if (!buf.isEmpty()){
        pa->io_primer_min_size=buf.toInt();
    }
//25
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MAX_SIZE");
    if (!buf.isEmpty()){
        pa->io_primer_max_size=buf.toInt();
    }
//26
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_SELF_ANY");
    if (!buf.isEmpty()){
        pa->io_self_any=(short)(buf.toDouble()*100);
    }
//27
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_SELF_END");
    if (!buf.isEmpty()){
        pa->io_self_end=(short)(buf.toDouble()*100);
    }
//28
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MAX_TM");
    if (!buf.isEmpty()){
        pa->io_max_tm=buf.toDouble();
    }
//29
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MIN_TM");
    if (!buf.isEmpty()){
        pa->io_min_tm=buf.toDouble();
    }
//30
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MAX_GC");
    if (!buf.isEmpty()){
        pa->io_max_gc=buf.toDouble();
    }
//31
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MIN_GC");
    if (!buf.isEmpty()){
        pa->io_min_gc=buf.toDouble();
    }
//32
    buf = elInput.attribute("PRIMER_LEFT_INPUT");
    if (!buf.isEmpty()){
        sa->left_input=stringToChar(buf);
    }
//33
    buf = elInput.attribute("PRIMER_RIGHT_INPUT");
    if (!buf.isEmpty()){
        sa->right_input=stringToChar(buf);
    }
//34
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_INPUT");
    if (!buf.isEmpty()){
        sa->internal_input=stringToChar(buf);
    }
//35
    buf = elInput.attribute("MARKER_NAME");
    if (!buf.isEmpty()){
        sa->sequence_name=stringToChar(buf);
    }
//36
    buf = elInput.attribute("PRIMER_DEFAULT_SIZE");
    if (!buf.isEmpty()){
        pa->primer_opt_size=buf.toInt();
    }
//37
    buf = elInput.attribute("PRIMER_DEFAULT_PRODUCT");
    if (!buf.isEmpty()){
        int i=0;
        foreach(QString str,buf.split(' ',QString::SkipEmptyParts)){
            pa->pr_min[i]=str.split('-')[0].toInt();
            pa->pr_max[i]=str.split('-')[1].toInt();
            i++;
        }
        pa->num_intervals=i;
    }
//38
    buf = elInput.attribute("EXCLUDED_REGION");
    if (!buf.isEmpty()){
        int i=0;
        foreach(QString str,buf.split(' ',QString::SkipEmptyParts)){
            sa->excl[i][0]=str.split(',')[0].toInt();
            sa->excl[i][1]=str.split(',')[1].toInt();
            i++;
        }
        sa->num_excl=i;
    }
//39
    buf = elInput.attribute("PRIMER_START_CODON_POSITION");
    if (!buf.isEmpty()){
        sa->start_codon_pos=buf.toInt();
    }
//40
    buf = elInput.attribute("PRIMER_OPT_TM");
    if (!buf.isEmpty()){
        pa->opt_tm=buf.toDouble();
    }
//41
    buf = elInput.attribute("PRIMER_OPT_GC_PERCENT");
    if (!buf.isEmpty()){
        pa->opt_gc_content=buf.toDouble();
    }
//42
    buf = elInput.attribute("PRIMER_MAX_DIFF_TM");
    if (!buf.isEmpty()){
        pa->max_diff_tm=buf.toDouble();
    }
//43
    buf = elInput.attribute("PRIMER_TM_SANTALUCIA");
    if (!buf.isEmpty()){
        pa->tm_santalucia=buf.toInt();
    }
//44
    buf = elInput.attribute("PRIMER_SALT_CORRECTIONS");
    if (!buf.isEmpty()){
        pa->salt_corrections=buf.toInt();
    }
//45
    buf = elInput.attribute("PRIMER_SALT_CONC");
    if (!buf.isEmpty()){
        pa->salt_conc=buf.toDouble();
    }
//46
    buf = elInput.attribute("PRIMER_DIVALENT_CONC");
    if (!buf.isEmpty()){
        pa->divalent_conc=buf.toDouble();
    }
//47
    buf = elInput.attribute("PRIMER_DNTP_CONC");
    if (!buf.isEmpty()){
        pa->dntp_conc=buf.toDouble();
    }
//48
    buf = elInput.attribute("PRIMER_DNA_CONC");
    if (!buf.isEmpty()){
        pa->dna_conc=buf.toDouble();
    }
//49
    buf = elInput.attribute("PRIMER_PRODUCT_OPT_SIZE");
    if (!buf.isEmpty()){
        pa->product_opt_size=buf.toInt();
    }
//50
    buf = elInput.attribute("PRIMER_PICK_ANYWAY");
    if (!buf.isEmpty()){
        pa->pick_anyway=buf.toInt();
    }
//51
    buf = elInput.attribute("PRIMER_GC_CLAMP");
    if (!buf.isEmpty()){
        pa->gc_clamp=buf.toInt();
    }
//52
    buf = elInput.attribute("PRIMER_LIBERAL_BASE");
    if (!buf.isEmpty()){
        pa->liberal_base=buf.toInt();
    }
//53
    buf = elInput.attribute("PRIMER_NUM_RETURN");
    if (!buf.isEmpty()){
        pa->num_return=buf.toInt();
    }
//54
    buf = elInput.attribute("PRIMER_MIN_QUALITY");
    if (!buf.isEmpty()){
        pa->min_quality=buf.toInt();
    }
//55
    buf = elInput.attribute("PRIMER_MIN_END_QUALITY");
    if (!buf.isEmpty()){
        pa->min_end_quality=buf.toInt();
    }
//56
    buf = elInput.attribute("PRIMER_QUALITY_RANGE_MIN");
    if (!buf.isEmpty()){
        pa->quality_range_min=buf.toInt();
    }
//57
    buf = elInput.attribute("PRIMER_QUALITY_RANGE_MAX");
    if (!buf.isEmpty()){
        pa->quality_range_max=buf.toInt();
    }
//58
    buf = elInput.attribute("PRIMER_PRODUCT_MAX_TM");
    if (!buf.isEmpty()){
        pa->product_max_tm=buf.toDouble();
    }
//59
    buf = elInput.attribute("PRIMER_PRODUCT_MIN_TM");
    if (!buf.isEmpty()){
        pa->product_min_tm=buf.toDouble();
    }
//60
    buf = elInput.attribute("PRIMER_PRODUCT_OPT_TM");
    if (!buf.isEmpty()){
        pa->product_opt_tm=buf.toDouble();
    }
//61
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_OPT_TM");
    if (!buf.isEmpty()){
        pa->io_opt_tm=buf.toDouble();
    }
//62
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_OPT_GC_PERCENT");
    if (!buf.isEmpty()){
        pa->io_opt_gc_content=buf.toDouble();
    }
//63
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_SALT_CONC");
    if (!buf.isEmpty()){
        pa->io_salt_conc=buf.toDouble();
    }
//64
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_DIVALENT_CONC");
    if (!buf.isEmpty()){
        pa->io_divalent_conc=buf.toDouble();
    }
//65
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_DNTP_CONC");
    if (!buf.isEmpty()){
        pa->io_dntp_conc=buf.toDouble();
    }
//66
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_DNA_CONC");
    if (!buf.isEmpty()){
        pa->io_dna_conc=buf.toDouble();
    }
//67
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_NUM_NS");
    if (!buf.isEmpty()){
        pa->io_num_ns_accepted=buf.toInt();
    }
//68
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MIN_QUALITY");
    if (!buf.isEmpty()){
        pa->io_min_quality=buf.toInt();
    }
//69
    buf = elInput.attribute("PRIMER_MAX_MISPRIMING");
    if (!buf.isEmpty()){
        pa->repeat_compl=(short)(buf.toDouble()*100);
    }
//70
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MAX_MISHYB");
    if (!buf.isEmpty()){
        pa->io_repeat_compl=(short)(buf.toDouble()*100);
    }
//71
    buf = elInput.attribute("PRIMER_PAIR_MAX_MISPRIMING");
    if (!buf.isEmpty()){
        pa->pair_repeat_compl=(short)(buf.toDouble()*100);
    }
//72
    buf = elInput.attribute("PRIMER_MAX_TEMPLATE_MISPRIMING");
    if (!buf.isEmpty()){
        pa->max_template_mispriming=(short)(buf.toDouble()*100);
    }
//73
    buf = elInput.attribute("PRIMER_PAIR_MAX_TEMPLATE_MISPRIMING");
    if (!buf.isEmpty()){
        pa->pair_max_template_mispriming=(short)(buf.toDouble()*100);
    }
//74
    buf = elInput.attribute("PRIMER_INTERNAL_OLIGO_MAX_TEMPLATE_MISHYB");
    if (!buf.isEmpty()){
        pa->io_max_template_mishyb=(short)(buf.toDouble()*100);
    }
//75
    buf = elInput.attribute("PRIMER_LIB_AMBIGUITY_CODES_CONSENSUS");
    if (!buf.isEmpty()){
        pa->lib_ambiguity_codes_consensus=buf.toInt();
    }
//76
    buf = elInput.attribute("PRIMER_INSIDE_PENALTY");
    if (!buf.isEmpty()){
        pa->inside_penalty=buf.toDouble();
    }
//77
    buf = elInput.attribute("PRIMER_OUTSIDE_PENALTY");
    if (!buf.isEmpty()){
        pa->outside_penalty=buf.toDouble();
    }
//78
    buf = elInput.attribute("PRIMER_MAX_END_STABILITY");
    if (!buf.isEmpty()){
        pa->max_end_stability=buf.toDouble();
    }
//79
    buf = elInput.attribute("PRIMER_LOWERCASE_MASKING");
    if (!buf.isEmpty()){
        pa->lowercase_masking=buf.toInt();
    }
//80
    buf = elInput.attribute("PRIMER_WT_TM_GT");
    if (!buf.isEmpty()){
        pa->primer_weights.temp_gt=buf.toDouble();
    }
//81
    buf = elInput.attribute("PRIMER_WT_TM_LT");
    if (!buf.isEmpty()){
        pa->primer_weights.temp_lt=buf.toDouble();
    }
//82
    buf = elInput.attribute("PRIMER_WT_GC_PERCENT_GT");
    if (!buf.isEmpty()){
        pa->primer_weights.gc_content_gt=buf.toDouble();
    }
//83
    buf = elInput.attribute("PRIMER_WT_GC_PERCENT_LT");
    if (!buf.isEmpty()){
        pa->primer_weights.gc_content_lt=buf.toDouble();
    }
//84
    buf = elInput.attribute("PRIMER_WT_SIZE_LT");
    if (!buf.isEmpty()){
        pa->primer_weights.length_lt=buf.toDouble();
    }
//85
    buf = elInput.attribute("PRIMER_WT_SIZE_GT");
    if (!buf.isEmpty()){
        pa->primer_weights.length_gt=buf.toDouble();
    }
//86
    buf = elInput.attribute("PRIMER_WT_COMPL_ANY");
    if (!buf.isEmpty()){
        pa->primer_weights.compl_any=buf.toDouble();
    }
//87
    buf = elInput.attribute("PRIMER_WT_COMPL_END");
    if (!buf.isEmpty()){
        pa->primer_weights.compl_end=buf.toDouble();
    }
//88
    buf = elInput.attribute("PRIMER_WT_NUM_NS");
    if (!buf.isEmpty()){
        pa->primer_weights.num_ns=buf.toDouble();
    }
//89
    buf = elInput.attribute("PRIMER_WT_REP_SIM");
    if (!buf.isEmpty()){
        pa->primer_weights.repeat_sim=buf.toDouble();
    }
//90
    buf = elInput.attribute("PRIMER_WT_SEQ_QUAL");
    if (!buf.isEmpty()){
        pa->primer_weights.seq_quality=buf.toDouble();
    }
//91
    buf = elInput.attribute("PRIMER_WT_END_QUAL");
    if (!buf.isEmpty()){
        pa->primer_weights.end_quality=buf.toDouble();
    }
//92
    buf = elInput.attribute("PRIMER_WT_POS_PENALTY");
    if (!buf.isEmpty()){
        pa->primer_weights.pos_penalty=buf.toDouble();
    }
//93
    buf = elInput.attribute("PRIMER_WT_END_STABILITY");
    if (!buf.isEmpty()){
        pa->primer_weights.end_stability=buf.toDouble();
    }
//94
    buf = elInput.attribute("PRIMER_WT_TEMPLATE_MISPRIMING");
    if (!buf.isEmpty()){
        pa->primer_weights.template_mispriming=buf.toDouble();
    }
//95
    buf = elInput.attribute("PRIMER_IO_WT_TM_GT");
    if (!buf.isEmpty()){
        pa->io_weights.temp_gt=buf.toDouble();
    }
//96
    buf = elInput.attribute("PRIMER_IO_WT_TM_LT");
    if (!buf.isEmpty()){
        pa->io_weights.temp_lt=buf.toDouble();
    }
//97
    buf = elInput.attribute("PRIMER_IO_WT_GC_PERCENT_GT");
    if (!buf.isEmpty()){
        pa->io_weights.gc_content_gt=buf.toDouble();
    }
//98
    buf = elInput.attribute("PRIMER_IO_WT_GC_PERCENT_LT");
    if (!buf.isEmpty()){
        pa->io_weights.gc_content_lt=buf.toDouble();
    }
//99
    buf = elInput.attribute("PRIMER_IO_WT_SIZE_LT");
    if (!buf.isEmpty()){
        pa->io_weights.length_lt=buf.toDouble();
    }
//100
    buf = elInput.attribute("PRIMER_IO_WT_SIZE_GT");
    if (!buf.isEmpty()){
        pa->io_weights.length_gt=buf.toDouble();
    }
//101
    buf = elInput.attribute("PRIMER_IO_WT_COMPL_ANY");
    if (!buf.isEmpty()){
        pa->io_weights.compl_any=buf.toDouble();
    }
//102
    buf = elInput.attribute("PRIMER_IO_WT_COMPL_END");
    if (!buf.isEmpty()){
        pa->io_weights.compl_end=buf.toDouble();
    }
//103
    buf = elInput.attribute("PRIMER_IO_WT_NUM_NS");
    if (!buf.isEmpty()){
        pa->io_weights.num_ns=buf.toDouble();
    }
//104
    buf = elInput.attribute("PRIMER_IO_WT_REP_SIM");
    if (!buf.isEmpty()){
        pa->io_weights.repeat_sim=buf.toDouble();
    }
//105
    buf = elInput.attribute("PRIMER_IO_WT_SEQ_QUAL");
    if (!buf.isEmpty()){
        pa->io_weights.seq_quality=buf.toDouble();
    }
//106
    buf = elInput.attribute("PRIMER_IO_WT_END_QUAL");
    if (!buf.isEmpty()){
        pa->io_weights.end_quality=buf.toDouble();
    }
//107
    buf = elInput.attribute("PRIMER_IO_WT_TEMPLATE_MISHYB");
    if (!buf.isEmpty()){
        pa->io_weights.template_mispriming=buf.toDouble();
    }
//108
    buf = elInput.attribute("PRIMER_PAIR_WT_PR_PENALTY");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.primer_quality=buf.toDouble();
    }
//109
    buf = elInput.attribute("PRIMER_PAIR_WT_IO_PENALTY");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.io_quality=buf.toDouble();
    }
//110
    buf = elInput.attribute("PRIMER_PAIR_WT_DIFF_TM");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.diff_tm=buf.toDouble();
    }
//111
    buf = elInput.attribute("PRIMER_PAIR_WT_COMPL_ANY");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.compl_any=buf.toDouble();
    }
//112
    buf = elInput.attribute("PRIMER_PAIR_WT_COMPL_END");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.compl_end=buf.toDouble();
    }
//113
    buf = elInput.attribute("PRIMER_PAIR_WT_PRODUCT_TM_LT");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.product_tm_lt=buf.toDouble();
    }
//114
    buf = elInput.attribute("PRIMER_PAIR_WT_PRODUCT_TM_GT");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.product_tm_gt=buf.toDouble();
    }
//115
    buf = elInput.attribute("PRIMER_PAIR_WT_PRODUCT_SIZE_GT");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.product_size_gt=buf.toDouble();
    }
//116
    buf = elInput.attribute("PRIMER_PAIR_WT_PRODUCT_SIZE_LT");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.product_size_lt=buf.toDouble();
    }
//117
    buf = elInput.attribute("PRIMER_PAIR_WT_REP_SIM");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.repeat_sim=buf.toDouble();
    }
//118
    buf = elInput.attribute("PRIMER_PAIR_WT_TEMPLATE_MISPRIMING");
    if (!buf.isEmpty()){
        pa->pr_pair_weights.template_mispriming=buf.toDouble();
    }
//119
    buf = elInput.attribute("PRIMER_TASK");
    if (!buf.isEmpty()){
        task_tmp=new QString(buf);
    }
//120
    buf = elInput.attribute("PRIMER_SEQUENCE_QUALITY");
    if (!buf.isEmpty()){
        QStringList qualityList=buf.split(' ',QString::SkipEmptyParts);
        n_quality=qualityList.size();
        for(int i=0;i<n_quality;i++){
            sa->quality[i]=qualityList.at(i).toInt();
        }
    }
    }
    //////////////////////////////////////////////////////////////////////////
    // Not implemented yet
    /*if (COMPARE("PRIMER_MISPRIMING_LIBRARY")) {
        if (repeat_file != NULL) {
            pr_append_new_chunk(&pa->glob_err,
                "Duplicate PRIMER_MISPRIMING_LIBRARY tag");
            free(repeat_file);
            repeat_file = NULL;
        } else {
            repeat_file = pr_safe_malloc(strlen(datum) + 1);
            strcpy(repeat_file, datum);
        }
        continue;
    }*/
    /*if (COMPARE("PRIMER_INTERNAL_OLIGO_MISHYB_LIBRARY")) {
        if (int_repeat_file != NULL) {
            pr_append_new_chunk(&pa->glob_err,
                "Duplicate PRIMER_INTERNAL_OLIGO_MISHYB_LIBRARY tag");
            free(int_repeat_file);
            int_repeat_file = NULL;
        } else {
            int_repeat_file = pr_safe_malloc(strlen(datum) + 1);
            strcpy(int_repeat_file, datum);
        }
        continue;
    }*/

    //////////////////////////////////////////////////////////////////////////
    // Check parameters
    QDomNodeList outputParameters = el.elementsByTagName("plugin_primer_3_out");
    for(int i=0;i<outputParameters.size(); i++) {
        QDomNode n = outputParameters.item(i);
        assert(n.isElement());
        if (!n.isElement()) {
            continue;
        }
        QDomElement elOutput = n.toElement();
        buf = elOutput.attribute("PRIMER_PAIRS_NUMBER");
	expectedBestPairs.storage_size = expectedBestPairs.num_pairs=0;
        if (!buf.isEmpty()){            
            expectedBestPairs.storage_size = expectedBestPairs.num_pairs=buf.toInt();
            expectedBestPairs.pairs=(primer_pair *)pr_safe_malloc(expectedBestPairs.num_pairs * sizeof(primer_pair));
        }

        if (expectedBestPairs.num_pairs>0)
        {
            expectedBestPairs.pairs->left=(primer_rec *)pr_safe_malloc(sizeof(primer_rec));
            expectedBestPairs.pairs->right=(primer_rec *)pr_safe_malloc(sizeof(primer_rec));

            buf = elOutput.attribute("PRIMER_LEFT");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->left->start=buf.split(',')[0].toInt();
                expectedBestPairs.pairs->left->length=buf.split(',')[1].toInt();
            }
            buf = elOutput.attribute("PRIMER_RIGHT");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->right->start=buf.split(',')[0].toInt();
                expectedBestPairs.pairs->right->length=buf.split(',')[1].toInt();
            }
            expectedBestPairs.pairs->intl=NULL;
            buf = elOutput.attribute("PRIMER_INTERNAL_OLIGO");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->intl=(primer_rec *)pr_safe_malloc(sizeof(primer_rec));//???
                expectedBestPairs.pairs->intl->start=buf.split(',')[0].toInt();
                expectedBestPairs.pairs->intl->length=buf.split(',')[1].toInt();
            }
            buf = elOutput.attribute("PRIMER_LEFT_TM");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->left->temp=buf.toDouble();
            }
            buf = elOutput.attribute("PRIMER_RIGHT_TM");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->right->temp=buf.toDouble();
            }
            buf = elOutput.attribute("PRIMER_INTERNAL_OLIGO_TM");
            if (!buf.isEmpty()&&expectedBestPairs.pairs->intl!=NULL){
                expectedBestPairs.pairs->intl->temp=buf.toDouble();
            }
            buf = elOutput.attribute("PRIMER_LEFT_GC_PERCENT");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->left->gc_content=buf.toDouble();
            }
            buf = elOutput.attribute("PRIMER_RIGHT_GC_PERCENT");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->right->gc_content=buf.toDouble();
            }
            buf = elOutput.attribute("PRIMER_INTERNAL_OLIGO_GC_PERCENT");
            if (!buf.isEmpty()&&expectedBestPairs.pairs->intl!=NULL){
                expectedBestPairs.pairs->intl->gc_content=buf.toDouble();
            }
            buf = elOutput.attribute("PRIMER_LEFT_SELF_ANY");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->left->self_any=(short)(buf.toDouble()*100);
            }
            buf = elOutput.attribute("PRIMER_RIGHT_SELF_ANY");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->right->self_any=(short)(buf.toDouble()*100);
            }
            buf = elOutput.attribute("PRIMER_INTERNAL_OLIGO_SELF_ANY");
            if (!buf.isEmpty()&&expectedBestPairs.pairs->intl!=NULL){
                expectedBestPairs.pairs->intl->self_any=(short)(buf.toDouble()*100);
            }
            buf = elOutput.attribute("PRIMER_LEFT_SELF_END");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->left->self_end=(short)(buf.toDouble()*100);
            }
            buf = elOutput.attribute("PRIMER_RIGHT_SELF_END");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->right->self_end=(short)(buf.toDouble()*100);
            }
            buf = elOutput.attribute("PRIMER_INTERNAL_OLIGO_SELF_END");
            if (!buf.isEmpty()&&expectedBestPairs.pairs->intl!=NULL){
                expectedBestPairs.pairs->intl->self_end=(short)(buf.toDouble()*100);
            }
            buf = elOutput.attribute("PRIMER_LEFT_END_STABILITY");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->left->end_stability=buf.toDouble();
            }
            buf = elOutput.attribute("PRIMER_RIGHT_END_STABILITY");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->right->end_stability=buf.toDouble();
            }
            buf = elOutput.attribute("PRIMER_PAIR_COMPL_ANY");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->compl_any=(int)(buf.toDouble()*100);
            }
            buf = elOutput.attribute("PRIMER_PAIR_COMPL_END");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->compl_end=(int)(buf.toDouble()*100);
            }
            buf = elOutput.attribute("PRIMER_PRODUCT_SIZE");
            if (!buf.isEmpty()){
                expectedBestPairs.pairs->product_size=buf.toInt();
            }

            for (int i=1;i<expectedBestPairs.num_pairs;i++)
            {
                buf = elOutput.attribute(QString("PRIMER_LEFT_%1").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].left=(primer_rec *)pr_safe_malloc(sizeof(primer_rec));
                    expectedBestPairs.pairs[i].left->start=buf.split(',')[0].toInt();
                    expectedBestPairs.pairs[i].left->length=buf.split(',')[1].toInt();
                }
                buf = elOutput.attribute(QString("PRIMER_RIGHT_%1").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].right=(primer_rec *)pr_safe_malloc(sizeof(primer_rec));
                    expectedBestPairs.pairs[i].right->start=buf.split(',')[0].toInt();
                    expectedBestPairs.pairs[i].right->length=buf.split(',')[1].toInt();
                }
                expectedBestPairs.pairs[i].intl=NULL;
                buf = elOutput.attribute(QString("PRIMER_INTERNAL_OLIGO_%1").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].intl=(primer_rec *)pr_safe_malloc(sizeof(primer_rec));
                    expectedBestPairs.pairs[i].intl->start=buf.split(',')[0].toInt();
                    expectedBestPairs.pairs[i].intl->length=buf.split(',')[1].toInt();
                }
                buf = elOutput.attribute(QString("PRIMER_LEFT_%1_TM").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].left->temp=buf.toDouble();
                }
                buf = elOutput.attribute(QString("PRIMER_RIGHT_%1_TM").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].right->temp=buf.toDouble();
                }
                buf = elOutput.attribute(QString("PRIMER_INTERNAL_OLIGO_%1_TM").arg(i));
                if (!buf.isEmpty()&&expectedBestPairs.pairs[i].intl!=NULL){
                    expectedBestPairs.pairs[i].intl->temp=buf.toDouble();
                }
                buf = elOutput.attribute(QString("PRIMER_LEFT_%1_GC_PERCENT").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].left->gc_content=buf.toDouble();
                }
                buf = elOutput.attribute(QString("PRIMER_RIGHT_%1_GC_PERCENT").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].right->gc_content=buf.toDouble();
                }
                buf = elOutput.attribute(QString("PRIMER_INTERNAL_OLIGO_%1_GC_PERCENT").arg(i));
                if (!buf.isEmpty()&&expectedBestPairs.pairs[i].intl!=NULL){
                    expectedBestPairs.pairs[i].intl->gc_content=buf.toDouble();
                }
                buf = elOutput.attribute(QString("PRIMER_LEFT_%1_SELF_ANY").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].left->self_any=(short)(buf.toDouble()*100);
                }
                buf = elOutput.attribute(QString("PRIMER_RIGHT_%1_SELF_ANY").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].right->self_any=(short)(buf.toDouble()*100);
                }
                buf = elOutput.attribute(QString("PRIMER_INTERNAL_OLIGO_%1_SELF_ANY").arg(i));
                if (!buf.isEmpty()&&expectedBestPairs.pairs[i].intl!=NULL){
                    expectedBestPairs.pairs[i].intl->self_any=(short)(buf.toDouble()*100);
                }
                buf = elOutput.attribute(QString("PRIMER_LEFT_%1_SELF_END").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].left->self_end=(short)(buf.toDouble()*100);
                }
                buf = elOutput.attribute(QString("PRIMER_RIGHT_%1_SELF_END").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].right->self_end=(short)(buf.toDouble()*100);
                }
                buf = elOutput.attribute(QString("PRIMER_INTERNAL_OLIGO_%1_SELF_END").arg(i));
                if (!buf.isEmpty()&&expectedBestPairs.pairs[i].intl!=NULL){
                    expectedBestPairs.pairs[i].intl->self_end=(short)(buf.toDouble()*100);
                }
                buf = elOutput.attribute(QString("PRIMER_LEFT_%1_END_STABILITY").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].left->end_stability=buf.toDouble();
                }
                buf = elOutput.attribute(QString("PRIMER_RIGHT_%1_END_STABILITY").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].right->end_stability=buf.toDouble();
                }
                buf = elOutput.attribute(QString("PRIMER_PAIR_%1_COMPL_ANY").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].compl_any=(int)(buf.toDouble()*100);
                }
                buf = elOutput.attribute(QString("PRIMER_PAIR_%1_COMPL_END").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].compl_end=(int)(buf.toDouble()*100);
                }
                buf = elOutput.attribute(QString("PRIMER_PRODUCT_SIZE_%1").arg(i));
                if (!buf.isEmpty()){
                    expectedBestPairs.pairs[i].product_size=buf.toInt();
                }

            }
        }
    }
    //////////////////////////////////////////////////////////////////////////
    //hacking code from boulder_input.c
    if(task_tmp != NULL) {
        if (task_tmp->compare("pick_pcr_primers",Qt::CaseInsensitive)==0)
            pa->primer_task = pick_pcr_primers;
        else if (task_tmp->compare("pick_pcr_primers_and_hyb_probe",Qt::CaseInsensitive)==0)
            pa->primer_task = pick_pcr_primers_and_hyb_probe;
        else if (task_tmp->compare("pick_left_only",Qt::CaseInsensitive)==0)
            pa->primer_task = pick_left_only;
        else if (task_tmp->compare("pick_right_only",Qt::CaseInsensitive)==0)
            pa->primer_task = pick_right_only;
        else if (task_tmp->compare("pick_hyb_probe_only",Qt::CaseInsensitive)==0)
            pa->primer_task = pick_hyb_probe_only;
        else stateInfo.setError(GTest::tr("Unrecognized PRIMER_TASK"));//??? may be remove from this place
        free(task_tmp);
    }

    if (NULL == sa->sequence)
        stateInfo.setError(GTest::tr("Missing SEQUENCE tag"));//??? may be remove from this place
    else {
        int seq_len = strlen(sa->sequence);
        if (sa->incl_l == -1) {
            sa->incl_l = seq_len;
            sa->incl_s = pa->first_base_index;
        }
        if(n_quality !=0 && n_quality != seq_len)
            stateInfo.setError(GTest::tr("Error in sequence quality data"));//??? may be remove from this place
        if((pa->min_quality != 0 || pa->io_min_quality != 0) && n_quality == 0) 
            stateInfo.setError(GTest::tr("Sequence quality data missing"));//??? may be remove from this place
        if(pa->min_quality != 0 && pa->min_end_quality < pa->min_quality)
            pa->min_end_quality = pa->min_quality;
    }

    /* 
    * WARNING: read_seq_lib uses read_line, so repeat files cannot be read
    * inside the while ((s = read_line(stdin))...)  loop above.
    */

    /*if (NULL != repeat_file) {
        if ('\0' == *repeat_file) {
            free_seq_lib(&pa->repeat_lib);
        }
        else {
            read_seq_lib(&pa->repeat_lib, repeat_file, "mispriming library");
            if(pa->repeat_lib.error.data != NULL) {
                pr_append_new_chunk(&pa->glob_err, pa->repeat_lib.error.data);
            }
        }
        free(repeat_file);
        repeat_file = NULL;
    }

    if (NULL != int_repeat_file) {
        if ('\0' == *int_repeat_file) {
            free_seq_lib(&pa->io_mishyb_library);
        }
        else {
            read_seq_lib(&pa->io_mishyb_library, int_repeat_file,
                "internal oligo mishyb library");
            if(pa->io_mishyb_library.error.data != NULL) {
                pr_append_new_chunk(&pa->glob_err, pa->io_mishyb_library.error.data);
            }
        }
        free(int_repeat_file);
        int_repeat_file = NULL;
    }*/

     /* Adjust base indexes in sa. */
    sa->incl_s -= pa->first_base_index;
    sa->start_codon_pos -= pa->first_base_index;
    adjust_base_index_interval_list(sa->tar, sa->num_targets,
        pa->first_base_index);
    adjust_base_index_interval_list(sa->excl, sa->num_excl,
        pa->first_base_index);
    adjust_base_index_interval_list(sa->excl_internal,
        sa->num_internal_excl,
        pa->first_base_index);
    //sa->start_codon_pos = PR_DEFAULT_START_CODON_POS;
}

void GTest_Primer3::prepare(){
    t = new Primer3Task(pa,sa);
}

void GTest_Primer3::run() {
    t->run();//???
}

Task::ReportResult GTest_Primer3::report(){

    currentBestPairs=t->getBestPairs();
    
    if(!(currentBestPairs.num_pairs==expectedBestPairs.num_pairs)){
        stateInfo.setError(GTest::tr("PRIMER_PAIRS_NUMBER is incorrect. Expected:%2, but Actual:%3").arg(expectedBestPairs.num_pairs).arg(currentBestPairs.num_pairs));
        return ReportResult_Finished;
    }
    
    for (int i=0;i<expectedBestPairs.num_pairs;i++)
    {
        if((currentBestPairs.pairs[i].left->start+ sa->incl_s + pa->first_base_index!=expectedBestPairs.pairs[i].left->start)||(currentBestPairs.pairs[i].left->length!=expectedBestPairs.pairs[i].left->length)){
            stateInfo.setError(GTest::tr("PRIMER_LEFT_%1 is incorrect. Expected:%2,%3, but Actual:%4,%5").arg(i)
                .arg(expectedBestPairs.pairs[i].left->start).arg((int)expectedBestPairs.pairs[i].left->length)
                .arg(currentBestPairs.pairs[i].left->start+ sa->incl_s + pa->first_base_index).arg((int)currentBestPairs.pairs[i].left->length));
            return ReportResult_Finished;
        }
        if((currentBestPairs.pairs[i].right->start+ sa->incl_s + pa->first_base_index!=expectedBestPairs.pairs[i].right->start)||(currentBestPairs.pairs[i].right->length!=expectedBestPairs.pairs[i].right->length)){
            stateInfo.setError(GTest::tr("PRIMER_RIGHT_%1 is incorrect. Expected:%2,%3, but Actual:%4,%5").arg(i)
                .arg(expectedBestPairs.pairs[i].right->start,expectedBestPairs.pairs[i].right->length)
                .arg(currentBestPairs.pairs[i].right->start+ sa->incl_s + pa->first_base_index,currentBestPairs.pairs[i].right->length));
            return ReportResult_Finished;
        }
        if(!compareDoubles(currentBestPairs.pairs[i].left->temp, expectedBestPairs.pairs[i].left->temp)){
            stateInfo.setError(GTest::tr("PRIMER_LEFT_%1_TM is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].left->temp).arg(currentBestPairs.pairs[i].left->temp));
            return ReportResult_Finished;
        }
        if(!compareDoubles(currentBestPairs.pairs[i].right->temp,expectedBestPairs.pairs[i].right->temp)){
            stateInfo.setError(GTest::tr("PRIMER_RIGHT_%1_TM is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].right->temp).arg(currentBestPairs.pairs[i].right->temp));
            return ReportResult_Finished;
        }
        if(!compareDoubles(currentBestPairs.pairs[i].left->gc_content, expectedBestPairs.pairs[i].left->gc_content)){
            stateInfo.setError(GTest::tr("PRIMER_LEFT_%1_GC_PERCENT is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].left->gc_content).arg(currentBestPairs.pairs[i].left->gc_content));
            return ReportResult_Finished;
        }
        if(!compareDoubles(currentBestPairs.pairs[i].right->gc_content,expectedBestPairs.pairs[i].right->gc_content)){
            stateInfo.setError(GTest::tr("PRIMER_RIGHT_%1_GC_PERCENT is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].right->gc_content).arg(currentBestPairs.pairs[i].right->gc_content));
            return ReportResult_Finished;
        }
        if(currentBestPairs.pairs[i].left->self_any!=expectedBestPairs.pairs[i].left->self_any){
            stateInfo.setError(GTest::tr("PRIMER_LEFT_%1_SELF_ANY is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].left->self_any).arg(currentBestPairs.pairs[i].left->self_any));
            return ReportResult_Finished;
        }
        if(currentBestPairs.pairs[i].right->self_any!=expectedBestPairs.pairs[i].right->self_any){
            stateInfo.setError(GTest::tr("PRIMER_RIGHT_%1_SELF_ANY is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].right->self_any).arg(currentBestPairs.pairs[i].right->self_any));
            return ReportResult_Finished;
        }
        if(currentBestPairs.pairs[i].left->self_end!=expectedBestPairs.pairs[i].left->self_end){
            stateInfo.setError(GTest::tr("PRIMER_LEFT_%1_SELF_END is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].left->self_end).arg(currentBestPairs.pairs[i].left->self_end));
            return ReportResult_Finished;
        }
        if(currentBestPairs.pairs[i].right->self_end!=expectedBestPairs.pairs[i].right->self_end){
            stateInfo.setError(GTest::tr("PRIMER_RIGHT_%1_SELF_END is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].right->self_end).arg(currentBestPairs.pairs[i].right->self_end));
            return ReportResult_Finished;
        }
        if(!compareDoubles(currentBestPairs.pairs[i].left->end_stability, expectedBestPairs.pairs[i].left->end_stability)){
            stateInfo.setError(GTest::tr("PRIMER_LEFT_%1_END_STABILITY is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].left->end_stability).arg(currentBestPairs.pairs[i].left->end_stability));
            return ReportResult_Finished;
        }
        if(!compareDoubles(currentBestPairs.pairs[i].right->end_stability,expectedBestPairs.pairs[i].right->end_stability)){
            stateInfo.setError(GTest::tr("PRIMER_RIGHT_%1_END_STABILITY is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].right->end_stability).arg(currentBestPairs.pairs[i].right->end_stability));
            return ReportResult_Finished;
        }
        if(currentBestPairs.pairs[i].compl_any!=expectedBestPairs.pairs[i].compl_any){
            stateInfo.setError(GTest::tr("PRIMER_PAIR_%1_COMPL_ANY is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].compl_any).arg(currentBestPairs.pairs[i].compl_any));
            return ReportResult_Finished;
        }
        if(currentBestPairs.pairs[i].compl_end!=expectedBestPairs.pairs[i].compl_end){
            stateInfo.setError(GTest::tr("PRIMER_PAIR_%1_COMPL_END is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].compl_end).arg(currentBestPairs.pairs[i].compl_end));
            return ReportResult_Finished;
        }
        if(currentBestPairs.pairs[i].compl_end!=expectedBestPairs.pairs[i].compl_end){
            stateInfo.setError(GTest::tr("PRIMER_PRODUCT_SIZE_%1 is incorrect. Expected:%2, but Actual:%3").arg(i)
                .arg(expectedBestPairs.pairs[i].product_size).arg(currentBestPairs.pairs[i].product_size));
            return ReportResult_Finished;
        }
        if(expectedBestPairs.pairs[i].intl!=NULL){
            if((currentBestPairs.pairs[i].intl->start+ sa->incl_s + pa->first_base_index!=expectedBestPairs.pairs[i].intl->start)||(currentBestPairs.pairs[i].intl->length!=expectedBestPairs.pairs[i].intl->length)){
                stateInfo.setError(GTest::tr("PRIMER_INTERNAL_OLIGO_%1 is incorrect. Expected:%2,%3, but Actual:%4,%5").arg(i)
                    .arg(expectedBestPairs.pairs[i].intl->start,expectedBestPairs.pairs[i].intl->length)
                    .arg(currentBestPairs.pairs[i].intl->start+ sa->incl_s + pa->first_base_index,currentBestPairs.pairs[i].intl->length));
                return ReportResult_Finished;
            }
            if(!compareDoubles(currentBestPairs.pairs[i].intl->temp,expectedBestPairs.pairs[i].intl->temp)){
                stateInfo.setError(GTest::tr("PRIMER_INTERNAL_OLIGO_%1_TM is incorrect. Expected:%2, but Actual:%3").arg(i)
                    .arg(expectedBestPairs.pairs[i].intl->temp).arg(currentBestPairs.pairs[i].intl->temp));
                return ReportResult_Finished;
            }
            if(!compareDoubles(currentBestPairs.pairs[i].intl->gc_content,expectedBestPairs.pairs[i].intl->gc_content)){
                stateInfo.setError(GTest::tr("PRIMER_INTERNAL_OLIGO_%1_GC_PERCENT is incorrect. Expected:%2, but Actual:%3").arg(i)
                    .arg(expectedBestPairs.pairs[i].intl->gc_content).arg(currentBestPairs.pairs[i].intl->gc_content));
                return ReportResult_Finished;
            }
            if(currentBestPairs.pairs[i].intl->self_any!=expectedBestPairs.pairs[i].intl->self_any){
                stateInfo.setError(GTest::tr("PRIMER_INTERNAL_OLIGO_%1_SELF_ANY is incorrect. Expected:%2, but Actual:%3").arg(i)
                    .arg(expectedBestPairs.pairs[i].intl->self_any).arg(currentBestPairs.pairs[i].intl->self_any));
                return ReportResult_Finished;
            }
            if(currentBestPairs.pairs[i].intl->self_end!=expectedBestPairs.pairs[i].intl->self_end){
                stateInfo.setError(GTest::tr("PRIMER_INTERNAL_OLIGO_%1_SELF_END is incorrect. Expected:%2, but Actual:%3").arg(i)
                    .arg(expectedBestPairs.pairs[i].intl->self_end).arg(currentBestPairs.pairs[i].intl->self_end));
                return ReportResult_Finished;
            }
        }else if (currentBestPairs.pairs[i].intl!=NULL)
        {
            /*stateInfo.setError(GTest::tr("PRIMER_INTERNAL_OLIGO_%1 must be NULL. But it is %2,%3").arg(i)
                .arg(currentBestPairs.pairs[i].intl->start+ sa->incl_s + pa->first_base_index,currentBestPairs.pairs[i].intl->length));
            return ReportResult_Finished;*/
        }
    }
/*    for (int i=0;i<currentBestPairs.num_pairs;i++)
    {
        //currentBestPairs->pairs[i]->
        if(!(currentBestPairs.pairs[i].left->position_penalty==expectedBestPairs.pairs[i].left->position_penalty)){
            stateInfo.setError(GTest::tr("PRIMER_LEFT_PENALTY_%1 is incorrect. Expected:%2, but Actual:%3").arg(i).arg(expectedBestPairs.pairs[i].left->position_penalty).arg(currentBestPairs.pairs[i].left->position_penalty));
            return ReportResult_Finished;
        }
    }
*/    

/*    need check error messages
-        PRIMER_PAIR_PENALTY="3.4770"

        PRIMER_LEFT_PENALTY="3.380952"
        PRIMER_LEFT_SEQUENCE="TGACNACTGACGATGCAGA"
        PRIMER_LEFT="15,19"
        PRIMER_LEFT_TM="57.619"
        PRIMER_LEFT_GC_PERCENT="50.000"
        PRIMER_LEFT_SELF_ANY="4.00"
        PRIMER_LEFT_SELF_END="0.00"
        PRIMER_LEFT_END_STABILITY="8.2000"

        PRIMER_RIGHT_PENALTY="0.096021"
        PRIMER_RIGHT_SEQUENCE="ATCGATTTGGGTCGGGAT"
        PRIMER_RIGHT="94,18"
        PRIMER_RIGHT_TM="60.096"
        PRIMER_RIGHT_GC_PERCENT="50.000"
        PRIMER_RIGHT_SELF_ANY="6.00"
        PRIMER_RIGHT_SELF_END="2.00"
        PRIMER_RIGHT_END_STABILITY="9.3000"

        PRIMER_INTERNAL_OLIGO_PENALTY="3.098711"
        PRIMER_INTERNAL_OLIGO_SEQUENCE="GGTATTAGTGGGCCATTCG"
        PRIMER_INTERNAL_OLIGO="58,19"
        PRIMER_INTERNAL_OLIGO_TM="57.901"
        PRIMER_INTERNAL_OLIGO_GC_PERCENT="52.632"
        PRIMER_INTERNAL_OLIGO_SELF_ANY="5.00"
        PRIMER_INTERNAL_OLIGO_SELF_END="2.00"


        PRIMER_PAIR_COMPL_ANY="4.00"
        PRIMER_PAIR_COMPL_END="3.00"
        PRIMER_PRODUCT_SIZE="80"
*/

    return ReportResult_Finished;
}

void GTest_Primer3::cleanup(){

}

GTest_Primer3::~GTest_Primer3() {      
    if (expectedBestPairs.num_pairs > 0) {
        for (int i = 0; i < expectedBestPairs.num_pairs; i++) {              
            if (expectedBestPairs.pairs[i].left != NULL) free(expectedBestPairs.pairs[i].left);
            if (expectedBestPairs.pairs[i].right != NULL) free(expectedBestPairs.pairs[i].right);
            if (pa->primer_task == pick_pcr_primers_and_hyb_probe)
                if (expectedBestPairs.pairs[i].intl != NULL) free(expectedBestPairs.pairs[i].intl);
        }
        free(expectedBestPairs.pairs);    
    }  
    delete t;
}

char *GTest_Primer3::stringToChar(QString in) {
    QByteArray ba = in.toAscii(); 
    char *out = (char *)pr_safe_malloc(ba.size() + 1);
    strcpy(out, ba.data());    
    return out;
}
bool GTest_Primer3::compareDoubles(double referenceNumber, double checkedNumber) {
    double eps=referenceNumber/1000;
    if((referenceNumber-eps<=checkedNumber)&&(referenceNumber+eps>=checkedNumber)){
        return true;
    }else{
        return false;
    }
}
}