/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TEST_VIEW_CONTROLLER_H_
#define _GB2_TEST_VIEW_CONTROLLER_H_

#include <core_api/MainWindow.h>
#include <ui/ui_QtScriptDebugView.h>

#include <QtGui/QTreeWidgetItem>
#include <QtCore/QFile>

#include <qscriptdebugger.h>
#include <qscriptenginedebuggerfrontend.h>
#include <qscriptdebuggercodewidget_p.h>


namespace GB2 {

#define ULOG_CAT_PLUGIN_SCRIPT_DEBUGGER "Plugin: QtScriptDebug"

class GTestSuite;
class GTestRef;
class GTestState;
class TVTSItem;
class TVTestItem;
class TVItem;
class TestRunnerService;

class QtScriptDebugViewController : public MWMDIWindow, Ui::QtScriptDebugView {
    Q_OBJECT
public:
    QtScriptDebugViewController();

    virtual void setupMDIToolbar(QToolBar* tb);

private slots:
    void sl_loadScriptFileAction();
    void sl_runScriptFileAction();
    void sl_saveScriptFileAction();
    void sl_saveAsScriptFileAction();
    void sl_startDebugScriptFileAction();
    void sl_stopDebugScriptFileAction();
    void sl_textChanged();
    void sl_checkUncaughtExceptions();
    void sl_updateTitle();

protected:
    virtual bool onCloseEvent();

private:
    void updateState();
    QScriptEngine* initScriptEngine();

    QAction* loadScriptFileAction;
    QAction* runScriptFileAction;
    QAction* saveScriptFileAction;
    QAction* saveAsScriptFileAction;
    QAction* startDebugScriptFileAction;
    QAction* stopDebugScriptFileAction;

    QScriptEngine* engine;
    QScriptEngine* runEngine;
    QScriptDebugger* debugger;
    QScriptEngineDebuggerFrontend* debuggerFrontend;

    QScriptDebuggerCodeWidget* codeWidget;

    QFile* scriptFile ;
    QFile* jsTestHelperLib;

    QTime* startRunTime ;
    QTime* endRunTime;
    int time;
    bool isRunning;
    bool isDebuging;
    bool isScriptChanged;
    int testId;

};

}//namespace

#endif

