/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "muscle.h"
#include <stdio.h>
#include "muscle_context.h"

// Define XXXToStr(XXX x) functions for each enum type XXX.
#define s(t)	const char *t##ToStr(t x) { switch (x) { case t##_Undefined: return "Undefined";
#define c(t, x)	case t##_##x: return #x;
#define e(t)	} sprintf(getMuscleContext()->enumtostr.szMsg, #t "_%d", x); return getMuscleContext()->enumtostr.szMsg; }
#include "enums.h"

// Define StrToXXX(const char *Str) functions for each enum type XXX.
#define s(t)	t StrTo##t(const char *Str) { if (0) ;
#define c(t, x)	else if (0 == stricmp(#x, Str)) return t##_##x;
#define e(t)	Quit("Invalid value %s for type %s", Str, #t); return t##_Undefined; }
#include "enums.h"
