/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_APPSETTINGS_DIALOG_CONTROLLER_H_
#define _GB2_APPSETTINGS_DIALOG_CONTROLLER_H_

#include <ui/ui_AppSettingsDialog.h>

#include <QtGui/QTreeWidgetItem>
#include <QtCore/QTimerEvent>

class AppSettingsDialogTree;

namespace GB2 {

class AppSettingsGUIPageController;
class AppSettingsGUIPageState;
class AppSettingsGUIPageWidget;
class AppSettingsTreeItem;

class AppSettingsDialogController: public QDialog, public Ui_AppSettingsDialog {
    Q_OBJECT

public:
    AppSettingsDialogController(const QString& pageId = QString());

public slots:
    virtual void accept();
    virtual void reject();
    void sl_currentItemChanged ( QTreeWidgetItem * current, QTreeWidgetItem * previous );

protected:
    void timerEvent(QTimerEvent* e);

private:
    bool checkCurrentState(bool saveStateInItem, bool showError);
    bool turnPage(AppSettingsTreeItem* page);
    void registerPage(AppSettingsGUIPageController* page);
    
    AppSettingsTreeItem* findPageItem(const QString& id) const;

private:
    AppSettingsTreeItem*    currentPage;
};

class AppSettingsTreeItem : public QTreeWidgetItem {
public:
    AppSettingsTreeItem(AppSettingsGUIPageController* pageController);
    AppSettingsGUIPageController*   pageController;
    AppSettingsGUIPageState*        pageState;
    AppSettingsGUIPageWidget*       pageWidget;
};

}//namespace

#endif
