/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROJECT_SUPPORT_H_
#define _GB2_PROJECT_SUPPORT_H_

#include "../_tmp/ui/ui_CreateNewProjectWidget.h"

#include <core_api/ProjectModel.h>
#include <assert.h>

#include <QtGui/QtGui>

namespace GB2 {

class ProjectLoaderImpl : public ProjectLoader {
    Q_OBJECT
public:
    ProjectLoaderImpl();
	~ProjectLoaderImpl();

    virtual Task* openProjectTask(const QString& file, bool closeActiveProject);
    virtual Task* openProjectTask(const QList<QUrl>& urls, bool closeActiveProject);

    static QString getLastProjectURL();

private:
    void updateState();
	void updateRecentProjectsMenu();
    void prependToRecentProjects(const QString& pFile);
    void updateRecentItemsMenu();
    void prependToRecentItems(const QString& url);
    void rememberProjectURL();

private slots:
    void sl_newProject();
    void sl_newDocumentFromText();
    void sl_openProject();
	void sl_openRecentFile();
	void sl_serviceStateChanged(Service* s, ServiceState prevState);
    void sl_documentAdded(Document* doc);
    void sl_projectURLChanged(const QString& oldURL);

// QT 4.5.0 bug workaround
    void sl_updateRecentItemsMenu();
    
private:
    
	QAction* newProjectAction;
	QAction* openProjectAction;
    QAction* newDocumentFromtext;
    QAction* separatorAction1;
	QAction* separatorAction2;

	QMenu* recentProjectsMenu;
    QMenu* recentItemsMenu;
};


//////////////////////////////////////////////////////////////////////////
/// Dialogs

//TODO: merge project dir & project name fields

class ProjectDialogController : public QDialog, public Ui::CreateNewProjectDialog {
    Q_OBJECT
public:
    enum Mode {New_Project, Save_Project};
    ProjectDialogController(Mode m = New_Project);

    void updateState();

protected:
    void keyPressEvent ( QKeyEvent * event );

private slots:
    void sl_folderSelectClicked();
    void sl_fileNameEdited(const QString&);
    void sl_projectNameEdited(const QString&);
private:
    bool fileEditIsEmpty;
};


}//namespace
#endif
