##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

# include (core.pri)
include( ../ugene_globals.pri )
UGENE_RELATIVE_DESTDIR = ''


TEMPLATE = lib
QT += network xml script svg
CONFIG +=qt dll thread debug_and_release
DEFINES+= _GB2_CORE_BUILD_DLL_ QT_DLL QT_FATAL_ASSERT
INCLUDEPATH += src _tmp
use_bundled_zlib() {
    INCLUDEPATH += ../libs_3rdparty/zlib/src
}

LIBS += -L../_release
!use_bundled_zlib() {
    LIBS += -lz
} else {
    LIBS += -lzlib
}


!debug_and_release|build_pass {

    CONFIG(debug, debug|release) {
        TARGET = cored
        DEFINES+=_DEBUG
        CONFIG +=console
        DESTDIR=../_debug
        MOC_DIR=_tmp/moc/debug
        OBJECTS_DIR=_tmp/obj/debug
        LIBS += -L../_debug
        LIBS -= -L../_release
        use_bundled_zlib() {
            LIBS += -lzlibd
            LIBS -= -lzlib
        }
    }

    CONFIG(release, debug|release) {
        TARGET = core
        DESTDIR=../_release
        DEFINES+=NDEBUG
        MOC_DIR=_tmp/moc/release
        OBJECTS_DIR=_tmp/obj/release
    }
}

UI_DIR=_tmp/ui
RCC_DIR=_tmp/rcc


# Special compiler flags for windows configuration
win32 {
    QMAKE_CXXFLAGS_WARN_ON = -W3
    QMAKE_CFLAGS_WARN_ON = -W3
    LIBS+=Psapi.Lib
}

unix {
    target.path = $$UGENE_INSTALL_DIR/$$UGENE_RELATIVE_DESTDIR
    INSTALLS += target
}
