/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SmithWatermanTaskFactoryRegistry.h"

#include <QMutexLocker>
#include <QStringList>


namespace GB2 {

SmithWatermanTaskFactoryRegistry::SmithWatermanTaskFactoryRegistry(QObject* pOwn):
	QObject(pOwn)
{
}

SmithWatermanTaskFactoryRegistry::~SmithWatermanTaskFactoryRegistry()
{
	foreach (const SmithWatermanTaskFactory* factory, factories) {
		delete factory;
	}
}

bool SmithWatermanTaskFactoryRegistry::registerFactory(
                                                SmithWatermanTaskFactory* factory, 
                                                const QString& factoryId)
{
    QMutexLocker locker(&mutex);
    if (factories.contains(factoryId)) {
        return false;
    }
    factories[factoryId] = factory;
	return true;
}

SmithWatermanTaskFactory* SmithWatermanTaskFactoryRegistry::getFactory(const QString& factoryId) {
	return factories.value(factoryId, 0);
}

QStringList SmithWatermanTaskFactoryRegistry::getListFactoryNames() {
	return factories.keys();
}

bool SmithWatermanTaskFactoryRegistry::hadRegistered(const QString& factoryId) {
    return factories.contains(factoryId);
}

} // namespace
