/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "IOAdapterRegistryImpl.h"

#include <ioadapter/LocalFileAdapter.h>
#include <ioadapter/HttpFileAdapter.h>
#include <ioadapter/VFSAdapter.h>

namespace GB2 {

bool IOAdapterRegistryImpl::registerIOAdapter(IOAdapterFactory* io) {
	if (getIOAdapterFactoryById(io->getAdapterId())!=NULL) {
		return false;
	}
	adapters.push_back(io);
	return true;
}

bool IOAdapterRegistryImpl::unregisterIOAdapter(IOAdapterFactory* io)  {
	int n = adapters.removeAll(io);
	return n > 0;
}


IOAdapterFactory* IOAdapterRegistryImpl::getIOAdapterFactoryById(IOAdapterId id) const  {
	foreach (IOAdapterFactory* io, adapters) {
		if (io->getAdapterId() == id) {
			return io;
		}
	}
	return NULL;
}


void IOAdapterRegistryImpl::init() {
	registerIOAdapter(new LocalFileAdapterFactory(this));
	registerIOAdapter(new GzippedLocalFileAdapterFactory(this));
    registerIOAdapter( new HttpFileAdapterFactory(this) );
    registerIOAdapter( new GzippedHttpFileAdapterFactory(this) );
    registerIOAdapter( new VFSAdapterFactory(this) );
}

}//namespace
