/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_SEQUENCE_H_
#define _GB2_DNA_SEQUENCE_H_

#include <core_api/core_api.h>
#include "DNAInfo.h"
#include "DNAQuality.h"

#include <QtCore/QByteArray>

namespace  GB2 {

class DNAAlphabet;

class GB2_COREAPI_EXPORT DNASequence {
public:
    DNASequence(const QString& name, const QByteArray& s = QByteArray(), DNAAlphabet* a = NULL);
    DNASequence(const QByteArray& s = QByteArray(), DNAAlphabet* a = NULL) : seq(s), alphabet(a), quality(NULL) {}
 
    QVariantMap     info;
    QByteArray      seq;
    DNAAlphabet*    alphabet;
    DNAQuality      quality;

    QString getName() const {return DNAInfo::getName(info);}
    bool isNull() const {return !alphabet && seq.length() == 0;}
    int length() const {return seq.length();}
    bool hasQualityScores() const {return (!quality.isEmpty()); }
    const char* constData() const {return seq.constData();}
};

}//namespace

Q_DECLARE_METATYPE(GB2::DNASequence)

#endif
