/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PHYTREE_H_
#define _GB2_PHYTREE_H_

#include <core_api/core_api.h>

#include <QtCore/QSet>
#include <QtCore/QMap>
#include <QtCore/QVector>
#include <QtCore/QSharedData>

namespace GB2 {

class PhyBranch;
class PhyNode;

class GB2_COREAPI_EXPORT PhyTreeData : public QSharedData {
public:
    PhyTreeData();
    PhyTreeData(const PhyTreeData& other);
    ~PhyTreeData();
    QList<const PhyNode*> collectNodes() const;
    void validate() const;
	void print();

    PhyNode* rootNode;
};
typedef QSharedDataPointer<PhyTreeData> PhyTree;

class GB2_COREAPI_EXPORT PhyNode {
public:
    PhyNode();
    
    void validate(QList<const PhyNode*>& track) const;
    bool isConnected(const PhyNode* node) const;

    static PhyBranch* addBranch(PhyNode* node1, PhyNode* node2, double distance);
    static void removeBranch(PhyNode* node1, PhyNode* node2);

    PhyNode* clone() const;
    void addToTrack(QSet<const PhyNode*>& track) const;

    QString             name;
    QList<PhyBranch*>   branches;
    bool equals(PhyNode* other);
    void print(QList<PhyNode*>& nodes, int distance, int tab);
    void dumpBranches() const;
    ~PhyNode();
};

class GB2_COREAPI_EXPORT PhyBranch {
public:
    PhyBranch();
    
    PhyNode* node1;
    PhyNode* node2;
    double   distance;
};

class GB2_COREAPI_EXPORT PhyTreeUtils {
public:
    static int getNumSeqsFromNode(const PhyNode *node, const QSet<QString>& names);
};

}//namespace

#endif

