/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_DISTRIBUTED_TASK_H_
#define _GB2_DISTRIBUTED_TASK_H_

#include "RemoteMachine.h"
#include "TaskDistributor.h"

namespace GB2 {

/*
 * Distributed task. Scatters settings, runs RemoteTasks as subtasks, then gather results
 */
class GB2_COREAPI_EXPORT DistributedTask : public Task {
    Q_OBJECT
public:
    DistributedTask(const QString & taskFactoryId, const LocalTaskSettings &settings, TaskDistributor *, const QList< RemoteMachine* >& );
    virtual ~DistributedTask();
    
    virtual void prepare();
    virtual Task::ReportResult report();
    virtual QList< Task* > onSubTaskFinished( Task * subTask );
    
    /* Be careful. will be deleted in destructor */
    LocalTaskResult * getResult() const;
    
private:
    bool scatterSettings();
    
private:
    QString                             taskFactoryId;
    const LocalTaskSettings &           settings;
    TaskDistributor *                   distributor;
    QList< RemoteMachine* >             availableMachines;
    QList< LocalTaskResult* >           subTasksResults;
    /* deleted in destructor */
    LocalTaskResult *                   result;
   
    QList< LocalTaskSettings* >         settingsToDel;
    QList< LocalTaskSettings* >         subTasksSettings;
    QMap< qint64, LocalTaskSettings* >  runningTaskSettings; /* taskId -> settings map. */
    
}; // DistributedTask

} // GB2

#endif // _GB2_DISTRIBUTED_TASK_H
