/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_REMOTE_MACHINE_H_
#define _GB2_REMOTE_MACHINE_H_

#include <cassert>

#include <QtCore/QUuid>
#include <core_api/Task.h>
#include "ProtocolInfo.h"
#include "RemoteTaskError.h"
#include "Serializable.h"

namespace GB2 {

/* 
 * Base class for RemoteMachines. Should be implemented for each transport protocol.
 * Stores all needed remote machine info, performs remote requests.
 */
class GB2_COREAPI_EXPORT RemoteMachine {
public:
    virtual ~RemoteMachine();

    virtual RemoteTaskError runRemoteTask( const QString & taskFactoryId, const QVariant & settings, qint64 * taskId ) = 0;
    virtual RemoteTaskError cancelRemoteTask( qint64 taskId ) = 0;
    virtual RemoteTaskError deleteRemoteTask( qint64 taskId ) = 0;
    virtual RemoteTaskError getRemoteTaskCancelFlag( qint64 taskId, bool * cancelFlag ) = 0;
    virtual RemoteTaskError getRemoteTaskState( qint64 taskId, Task::State * state ) = 0;
    virtual RemoteTaskError getRemoteTaskProgress( qint64 taskId, int * progress ) = 0;
    virtual RemoteTaskError getRemoteTaskResult( qint64 taskId, QVariant * result ) = 0;
    virtual RemoteTaskError getRemoteTaskError( qint64 taskId, QString * errMsg ) = 0;
    virtual RemoteTaskError getUuid( QUuid * uuid ) = 0;
    virtual RemoteTaskError getServicesList( QStringList * list ) = 0;
    virtual RemoteTaskError getHostName( QString * hostname ) = 0;
    
}; // RemoteMachine

/*
 * Base class for remote machine settings
 */
class GB2_COREAPI_EXPORT RemoteMachineSettings : public HumanSerializable {
public:
    RemoteMachineSettings( ProtocolInfo * proto );
    virtual ~RemoteMachineSettings();

    QString getProtocolId() const;
    virtual QString toString() const = 0;
    
    virtual bool operator==( const RemoteMachineSettings& ) const = 0;
    
private:
    QString protoId;
    
}; // RemoteMachineSettings

/*
 * Base class for RemoteMachinesFactories
 */
class GB2_COREAPI_EXPORT RemoteMachineFactory {
public:
    virtual ~RemoteMachineFactory();
    
    virtual RemoteMachine * createInstance( const QString & serializedSettings ) const = 0;
    virtual RemoteMachine * createInstance( RemoteMachineSettings * settings ) const = 0;
    virtual RemoteMachineSettings * createSettings( const QString & serializedSettings ) const = 0;
    
}; // RemoteMachineFactory

} // GB2

#endif // GB2_REMOTE_MACHINE_H_
