/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_REMOTE_TASK_SERVER_H_
#define _GB2_REMOTE_TASK_SERVER_H_

#include <QtCore/QList>
#include <core_api/core_api.h>

namespace GB2 {

/*
 * Base class for each transport protocol server.
 * Listens for remote requests.
 * Each protocol has 1 object of this class for UGENE instance
 */
class GB2_COREAPI_EXPORT RemoteTaskServer {
public:
    virtual ~RemoteTaskServer();
    
    /* we give user a possibility to close his machine from others requests */
    virtual bool setEnabled( bool enable ) = 0; // returns if enabling was successfull
    virtual bool isEnabled() const = 0;
    
}; // RemoteTaskServer

} // GB2

#endif // _GB2_REMOTE_TASK_SERVER_H_
