/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_TASK_DISTRIBUTOR_H_
#define _GB2_TASK_DISTRIBUTOR_H_

#include <QtCore/QList>
#include "LocalTask.h"

namespace GB2 {

/*
 * Base class. Each algorithm needs its own distributor
 */
class GB2_COREAPI_EXPORT TaskDistributor {
public:
    virtual ~TaskDistributor(){}
    /*scatters task settings to some number of parts
      returns new allocated settings */
    virtual QList<LocalTaskSettings *> scatter( const LocalTaskSettings * settings)const = 0;
    /* returns new allocated results */
    virtual LocalTaskResult * gather(const QList<LocalTaskResult *> &results)const = 0;
    
}; // TaskDistributor

/*
 * Template to TaskDistributor. Makes it easier to write own TaskDistributor implementation.
 */
template<class SettingsT, class ResultT>
class GB2_COREAPI_EXPORT TaskDistributorTemplate : public TaskDistributor {
public:
    virtual QList<LocalTaskSettings *> scatter( LocalTaskSettings * settings)const
    {
        SettingsT *castedSettings = dynamic_cast<SettingsT *>(settings);
        if(NULL == castedSettings)
        {
            return QList<LocalTaskSettings *>();
        }
        QList<LocalTaskSettings *> settingsList;
        foreach(SettingsT *settings, scatter(castedSettings))
        {
            settingsList.append(settings);
        }
        return settingsList;
    }
    virtual LocalTaskResult *gather(const QList<LocalTaskResult *> &results)const
    {
        QList<ResultT *> castedResults;
        foreach(LocalTaskResult *result, results)
        {
            ResultT *castedResult = dynamic_cast<ResultT *>(result);
            if(NULL == castedResult)
            {
                return NULL;
            }
            castedResults.append(castedResult);
        }
        return gather(castedResults);
    }

    virtual QList<SettingsT *> scatter(const SettingsT *settings)const = 0;
    virtual ResultT *gather(const QList<const ResultT *> &results)const = 0;
    
}; // TaskDistributorTemplate

} // GB2

#endif // _GB2_TASK_DISTRIBUTOR_H_
