/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SRFASTA_FORMAT_H_
#define _GB2_SRFASTA_FORMAT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>

namespace GB2 {

class IOAdapter;

// Short Reads Fasta - multiple alignment format for dna assembly
// The specification is the following
//
// First line: tag - # SHORT READS FASTA
// Then sequence data:
// > SEQNAME1 OFFSET1
// SEQDATA1
// > SEQNAME2 OFFSET2
// SEQDATA2
// etc...

// Example:
// # SHORT READS FASTA
// > seq1 0
// > AAAAAACCCCCC
// > seq2 5
// > CCCCCCTTTTTT
// > seq3 10
// > TTTTTTAAAAAA


class GB2_COREAPI_EXPORT  SRFastaFormat : public DocumentFormat {
    Q_OBJECT
public:
	SRFastaFormat(QObject* p);

    virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::SRF;}

	virtual const QString& getFormatName() const {return formatName;}

	virtual Document* loadDocument( IOAdapter* io, TaskStateInfo& ti, const QVariantMap& fs, DocumentLoadMode mode = DocumentLoadMode_Whole);
    
    virtual void storeDocument( Document* d, TaskStateInfo& ts, IOAdapter* io );

    virtual bool checkRawData(const QByteArray& rawData) const;
    
    static const QByteArray formatTag;
    static const QByteArray offsetTag;

private:
   
	QString formatName;
};

}//namespace

#endif // _GB2_SRFASTA_FORMAT_H_
