/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TEXT_OBJECT_H_
#define _GB2_TEXT_OBJECT_H_

#include <core_api/GObject.h>
#include "GObjectTypes.h"

namespace GB2 {

class GB2_COREAPI_EXPORT TextObject: public GObject {
    Q_OBJECT
public:
    TextObject(const QString& _text, const QString& objectName, const QVariantMap& hintsMap = QVariantMap()) 
        : GObject(GObjectTypes::TEXT, objectName, hintsMap), text(_text){};

    virtual const QString& getText() const {return text;}

    virtual void setText(const QString& newText);

    virtual GObject* clone() const;

protected:
    QString text;
};

}//namespace


#endif
