/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CreatePhyTreeDialogController.h"
#include "PhyTreeGeneratorRegistry.h"

#include <core_services/DocumentFormatRegistryImpl.h>
#include <core_api/AppContext.h>
#include <core_api/IOAdapter.h>
#include <core_api/SubstMatrixRegistry.h>
#include <core_api/GUrlUtils.h>
#include <core_api/DocumentUtils.h>
#include <gobjects/MAlignmentObject.h>
#include <util_gui/DialogUtils.h>

#include <QtGui/qfiledialog.h>
#include <QtGui/qmessagebox.h>

namespace GB2{

CreatePhyTreeDialogController::CreatePhyTreeDialogController(const MAlignmentObject* mobj, CreatePhyTreeSettings& _settings)
: QDialog(NULL), msa(mobj->getMAlignment()), settings(_settings){
    setupUi(this);
    verticalLayout->getContentsMargins ( NULL, NULL, &rightMargin, NULL );
    PhyTreeGeneratorRegistry* registry = AppContext::getPhyTreeGeneratorRegistry();
    QStringList nameList = registry->getNameList();
    for(int i=0; i<nameList.length(); i++){
        algorithmBox->addItem(nameList[i]);
    }
    const GUrl& msaURL = mobj->getDocument()->getURL();
    GUrl url = GUrlUtils::rollFileName(msaURL.dirPath() + "/" + msaURL.baseFileName() + ".nwk", DocumentUtils::getNewDocFileNameExcludesHint());
    connect(okButton, SIGNAL(clicked()), SLOT(sl_okClicked()));
    connect(browseButton, SIGNAL(clicked()), SLOT(sl_browseClicked()));
    
    fileNameEdit->setText(url.getURLString());
    PhyTreeGenerator* generator = registry->getGenerator(nameList.at(0));
    generator->setupCreatePhyTreeUI(this, msa);
    verticalLayout->activate();
    

}


void CreatePhyTreeDialogController::sl_okClicked(){
    
    settings.algorithmId = algorithmBox->currentText();
    if (fileNameEdit->text().isEmpty()) {
        QMessageBox::warning(this, tr("Warning"), tr("File name is empty"));
        fileNameEdit->setFocus();
        return;
    }
    settings.fileUrl = fileNameEdit->text();

    foreach (CreatePhyTreeWidget* widget, childWidgets) {
        widget->fillSettings(settings);
    }

    QDialog::accept();

}

void CreatePhyTreeDialogController::insertWidget( int pos, CreatePhyTreeWidget* widget )
{
    verticalLayout->insertWidget(pos,widget);
    childWidgets.append(widget);
    
    // adjust sizes
    setMinimumHeight(widget->minimumHeight() + minimumHeight());
    if (minimumWidth() < widget->minimumWidth()) {
        setMinimumWidth(widget->minimumWidth() + rightMargin*2);
    };
    widget->show();
}

void CreatePhyTreeDialogController::sl_browseClicked()
{
    GUrl oldUrl = fileNameEdit->text(); 
    QString path;
    LastOpenDirHelper lod;
    if (oldUrl.isEmpty()) {
        path = lod.dir;
    } else {
        path = oldUrl.getURLString();
    }
    GUrl newUrl = QFileDialog::getSaveFileName(this, "Choose file name", path,"Newick format (*.nwk)");
    
    if (newUrl.isEmpty()) {
        return;
    }
    fileNameEdit->setText(newUrl.getURLString());
    lod.url = newUrl.getURLString();


}
};
