/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _CREATEPHYTREEDIALOGCONTROLLER_H_
#define _CREATEPHYTREEDIALOGCONTROLLER_H_

#include "ui/ui_CreatePhyTreeDialog.h"
#include "core_api/core_api.h"
#include "CreatePhyTreeSettings.h"

namespace GB2{

class MAlignmentObject;
class MAlignment;

class GB2_COREAPI_EXPORT CreatePhyTreeWidget : public QWidget 
{
public:
    CreatePhyTreeWidget(QWidget* parent) : QWidget(parent) { }
    virtual void fillSettings(CreatePhyTreeSettings& settings) {Q_UNUSED(settings); } 
};


class GB2_COREAPI_EXPORT CreatePhyTreeDialogController : public QDialog, Ui_CreatePhyTree {
    Q_OBJECT
public:
    CreatePhyTreeDialogController(const MAlignmentObject* mobj, CreatePhyTreeSettings& settings);

    void insertWidget(int pos, CreatePhyTreeWidget* widget);

private slots:
    void sl_okClicked();
    void sl_browseClicked();
    
private:
    int rightMargin;
    const MAlignment& msa;
    CreatePhyTreeSettings& settings;
    QList<CreatePhyTreeWidget*> childWidgets;

};

}

#endif