/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef  __PHYTREEGENERATORTASK_H
#define  __PHYTREEGENERATORTASK_H

#include <core_api/Task.h>
#include "PhyTreeGenerator.h"
#include <phyltree/CreatePhyTreeSettings.h>

namespace GB2{
	
class GB2_COREAPI_EXPORT PhyTreeGeneratorTask: public Task{
    Q_OBJECT
public:
    PhyTreeGeneratorTask(const MAlignment& ma, const CreatePhyTreeSettings& _settings);
    ~PhyTreeGeneratorTask(){};
    void run();
    PhyTree getResult() { return result; }
    const CreatePhyTreeSettings& getSettings() { return settings; } 
    ReportResult report();
private:
    void calculateTree();
    PhyTreeGenerator*           generator;
    const MAlignment&           inputMA;
    PhyTree     			    result;
    CreatePhyTreeSettings       settings;

};

} //namespace

#endif
