/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_UTILS_H_
#define _GB2_MSA_UTILS_H_

#include <core_api/core_api.h>
#include <datatype/DNASequence.h>

namespace GB2 {

class GObject;
class MAlignment;
class MAlignmentRow;
class TaskStateInfo;

class GB2_COREAPI_EXPORT MSAUtils : public QObject {
    Q_OBJECT
public:

	static bool equalsIgnoreGaps(const MAlignmentRow& row, int startPos, const QByteArray& pattern);
    
    static MAlignment seq2ma(const QList<GObject*>& dnas, QString& err);

    static QList<DNASequence> ma2seq(const MAlignment& ma, bool trimGaps);

	//checks that alignment is not empty and all packed sequence parts has equal length
	static bool checkPackedModelSymmetry(MAlignment& ali, TaskStateInfo& ti);
};


}//namespace

#endif
