/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_ASSEMBLEY_GUI_EXTENSION_H_
#define _GB2_DNA_ASSEMBLEY_GUI_EXTENSION_H_

#include <core_api/core_api.h>
#include <core_api/GUrl.h>
#include <core_api/Task.h>

#include "DnaAssemblyTask.h"

namespace GB2 {


// These classes are intended for extending standard Dna Assembly dialog GUI
// with options specific to the assembly algorithm

class DnaAssemblyGUIExtensionWidget : public QWidget
{
public:
    DnaAssemblyGUIExtensionWidget(QWidget* parent) : QWidget(parent) {}
    virtual QMap<QString,QVariant> getDnaAssemblyCustomSettings() = 0;
};

class DnaAssemblyGUIExtensionFactory {
public:
    virtual DnaAssemblyGUIExtensionWidget* createGUIExtension(QWidget* parent) = 0;
};


#define DNA_ASSEMBLY_GUI_EXTENSION_FACTORY(c) \
public: \
    class Factory : public DnaAssemblyGUIExtensionFactory { \
    public: \
         DnaAssemblyGUIExtensionWidget* createGUIExtension(QWidget* parent) { return new c(parent); } \
    };



} // GB2


#endif // _GB2_DNA_ASSEMBLEY_GUI_EXTENSION_H_
