/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <QtGui/QLabel>
#include <QtGui/QMessageBox>

#include <core_api/AppContext.h>

#include "RemoteMachineAddDialogImpl.h"

namespace GB2 {

RemoteMachineAddDialogImpl::RemoteMachineAddDialogImpl() : newMachine( NULL ), currentUi( NULL ) {
    setupUi( this );
    
    ProtocolInfoRegistry * pir = AppContext::getProtocolInfoRegistry();
    assert( NULL != pir );
    QList< ProtocolInfo* > protoInfos = pir->getProtocolInfos();
    foreach( ProtocolInfo * pi, protoInfos ) {
        assert( NULL != pi );
        ProtocolUI * protoUI = pi->getProtocolUI();
        if( NULL != protoUI ) {
            protoUI->clearWidget();
            QString protoId = pi->getId();
            protoWidgets.insert( protoId, protoUI );
            protocolsComboBox->addItem( protoId );
        }
    }
    
    connect( cancelPushButton, SIGNAL( clicked() ), SLOT( reject() ) );
    connect( addPushButton, SIGNAL( clicked() ), SLOT( sl_addPushButtonClicked() ) );
    connect( protocolsComboBox, SIGNAL( activated( const QString & ) ), SLOT( sl_protoSelected( const QString & ) ) );
    
    if( 0 == protocolsComboBox->count() ) {
        QLabel * errorLable = new QLabel( tr( "No protocols found!" ), this );
        QVBoxLayout * topLayout = qobject_cast< QVBoxLayout* >( layout() );
        assert( NULL != topLayout );
        topLayout->insertWidget( 1, errorLable );
        
        addPushButton->setEnabled( false );
    } else {
        sl_protoSelected( protocolsComboBox->currentText() );
    }
}

RemoteMachineAddDialogImpl::~RemoteMachineAddDialogImpl() {
    delete newMachine;
    
    if( NULL != currentUi ) {
        QVBoxLayout * topLayout = qobject_cast< QVBoxLayout* >( layout() );
        assert( NULL != topLayout );
        currentUi->setParent( NULL );
    }
}

RemoteMachineSettings * RemoteMachineAddDialogImpl::getAddedMachine() const {
    return newMachine;
}

RemoteMachineSettings * RemoteMachineAddDialogImpl::takeAddedMachine() {
    RemoteMachineSettings * res = newMachine;
    newMachine = NULL;
    return res;
}

void RemoteMachineAddDialogImpl::sl_addPushButtonClicked() {
    QString protoId = protocolsComboBox->currentText();
    assert( !protoId.isEmpty() );
    ProtocolUI * protoUI = protoWidgets.value( protoId, NULL );
    assert( NULL != protoUI );
    
    QString error = protoUI->validate();
    if( !error.isEmpty() ) {
        QMessageBox::critical( this, tr( "Error!" ), error );
        return;
    }
    
    newMachine = protoUI->createMachine();
    if( NULL == newMachine ) {
        QMessageBox::critical( this, tr( "Error!" ), tr( "Sorry! Cannot create remote machine" ) );
        return;
    }
    QDialog::accept();
}

void RemoteMachineAddDialogImpl::sl_protoSelected( const QString & protoId ) {
    QVBoxLayout * topLayout = qobject_cast< QVBoxLayout* >( layout() );
    assert( NULL != topLayout );
    
    if( NULL != currentUi ) {
        topLayout->removeWidget( currentUi );
        currentUi->setParent( NULL );
        currentUi = NULL;
    }
    
    currentUi = protoWidgets.value( protoId );
    assert( NULL != currentUi );
    topLayout->insertWidget( 1, currentUi );
}

} // GB2
