/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_REMOTE_MACHINE_ADD_DIALOG_IMPL_H_
#define _GB2_REMOTE_MACHINE_ADD_DIALOG_IMPL_H_

#include <QtGui/QDialog>

#include <distributed_computing/RemoteMachine.h>
#include <distributed_computing/ProtocolUI.h>

#include <ui/ui_RemoteMachineAddDialog.h>

namespace GB2 {

class RemoteMachineAddDialogImpl : public QDialog, public Ui::RemoteMachineAddDialog {
    Q_OBJECT
public:
    RemoteMachineAddDialogImpl();
    ~RemoteMachineAddDialogImpl();
    
    RemoteMachineSettings * getAddedMachine() const;
    RemoteMachineSettings * takeAddedMachine();

private slots:
    void sl_addPushButtonClicked();
    void sl_protoSelected( const QString & );
    
private:
    RemoteMachineSettings *         newMachine;
    QMap< QString, ProtocolUI* >    protoWidgets;
    ProtocolUI *                    currentUi;
    
}; // RemoteMachineAddDialogImpl

} // GB2

#endif // _GB2_REMOTE_MACHINE_ADD_DIALOG_IMPL_H_
