/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_REMOTE_MACHINE_MODIFY_DIALOG_IMPL_H_
#define _GB2_REMOTE_MACHINE_MODIFY_DIALOG_IMPL_H_

#include <QtGui/QDialog>

#include <distributed_computing/RemoteMachine.h>

#include <ui/ui_RemoteMachineModifyDialog.h>

namespace GB2 {

class RemoteMachineModifyDialogImpl : public QDialog, public Ui::RemoteMachineModifyDialog {
    Q_OBJECT
public:
    RemoteMachineModifyDialogImpl( RemoteMachineSettings * machine );
    ~RemoteMachineModifyDialogImpl();
    
    RemoteMachineSettings * getNewModifiedMachine() const;
    RemoteMachineSettings * takeNewModifiedMachine();
    
private:
    void showErrorLabel( const QString & msg );
    
private slots:
    void sl_okPushButtonClicked();
    
private:
    RemoteMachineSettings * newMachine;
    ProtocolUI *            protoUi;
    
}; // RemoteMachineModifyDialogImpl

} // GB2

#endif // _GB2_REMOTE_MACHINE_MODIFY_DIALOG_IMPL_H_
