/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ALIGNMENT_LOGO_H_
#define _GB2_ALIGNMENT_LOGO_H_

#include <core_api/core_api.h>
#include <datatype/MAlignmentInfo.h>

#include <QtGui/QMainWindow>
#include <QtGui/QGraphicsItem>
#include "datatype/MAlignment.h"

namespace GB2 {

class MSAEditor;

enum SequenceType {Auto, NA, AA};
/************************************************************************/
/* Settings                                                             */
/************************************************************************/
class GB2_COREAPI_EXPORT AlignmentLogoSettings {
public:
    AlignmentLogoSettings(const MAlignment& _ma) : ma(_ma) {
        sequenceType = Auto;
        startPos = 0;
        len = ma.getLength();
        fontSize = 40;
        bitSize = 100;
        
        colorScheme.insert('S', Qt::green);
        colorScheme.insert('G', Qt::green);
        colorScheme.insert('H', Qt::green);
        colorScheme.insert('T', Qt::green);
        colorScheme.insert('A', Qt::green);
        colorScheme.insert('P', Qt::green);
        colorScheme.insert('Y', Qt::blue);
        colorScheme.insert('V', Qt::blue);
        colorScheme.insert('M', Qt::blue);
        colorScheme.insert('C', Qt::blue);
        colorScheme.insert('L', Qt::blue);
        colorScheme.insert('F', Qt::blue);
        colorScheme.insert('I', Qt::blue);
        colorScheme.insert('W', Qt::blue);
    }

    MAlignment              ma;
    SequenceType            sequenceType;
    int                     startPos;
    int                     len;
    int                     fontSize;//pixels
    int                     bitSize;
    QHash<char, QColor>     colorScheme;
};

/************************************************************************/
/* LogoRenderArea                                                       */
/************************************************************************/
class GB2_COREAPI_EXPORT AlignmentLogoRenderArea : public QWidget {
public:
    AlignmentLogoRenderArea(const AlignmentLogoSettings& s, QWidget* p);
    void replaceSettings(const AlignmentLogoSettings& s);

protected:
    virtual void paintEvent(QPaintEvent* e);

    void evaluateHeights();
    void sortCharsByHeight();
    qreal getH(int pos);

private:
    AlignmentLogoSettings           settings;
    qreal                           s;//4||20
    qreal                           error;
    QVector<char>*                  acceptableChars;
    QVector<char>                   bases;
    QVector<char>                   aminoacids;

    QVector<QVector<char> >         columns;
    //frequency and height of a particular char at position
    QHash<char, QVector<qreal> >    frequencies;
    QHash<char, QVector<qreal> >    heights;
};

/************************************************************************/
/* LogoItem                                                             */
/************************************************************************/
class AlignmentLogoItem : public QGraphicsItem {
public:
    AlignmentLogoItem(char _ch, QPointF _baseline, int _charHeight, QFont _font, QColor _color=Qt::black);

    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget /* = 0 */);
private:
    char            ch;
    QPointF         baseline;
    int             charHeight;
    QFont           font;
    QColor          color;
    QPainterPath    path;
};

}//namespace

#endif
