/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ConsensusSelectorDialogController.h"

#include <core_api/AppContext.h>
#include <core_api/Counter.h>
#include <util_msa_consensus/MSAConsensusAlgorithmRegistry.h>

namespace GB2 {

ConsensusSelectorDialogController::ConsensusSelectorDialogController(const QString& _selectedAlgorithmId, ConsensusAlgorithmFlags flags, QWidget* p) 
: QDialog(p) 
{
	setupUi(this);
    
	MSAConsensusAlgorithmRegistry* reg = AppContext::getMSAConsensusAlgorithmRegistry();
	QList<MSAConsensusAlgorithmFactory*> algos = reg->getAlgorithmFactories(flags);

    //TODO: sort algos by name
	foreach(const MSAConsensusAlgorithmFactory* algo, algos) {
		consensusCombo->addItem(QIcon(), algo->getName(), algo->getId());
	}

	selectedAlgorithmId = _selectedAlgorithmId;
	int indexToSelect = qMax(0, consensusCombo->findData(selectedAlgorithmId));
	consensusCombo->setCurrentIndex(indexToSelect);
    
    disableThresholdSelector();

	updateSelectedAlgorithmDesc();

    connect(consensusCombo, SIGNAL(currentIndexChanged(int)), SLOT(sl_algorithmSelectionChanged(int)));
    connect(thresholdSlider, SIGNAL(valueChanged(int)), SLOT(sl_thresholdSliderChanged(int)));
    connect(thresholdSpin, SIGNAL(valueChanged(int)), SLOT(sl_thresholdSpinChanged(int)));
    connect(thresholdDefaultButton, SIGNAL(clicked(bool)), SLOT(sl_resetThresholdClicked(bool)));
    
    GCOUNTER(cvar,tvar, "ConsensusSelectorDialog");
}

void ConsensusSelectorDialogController::sl_algorithmSelectionChanged(int i) {
	selectedAlgorithmId = consensusCombo->itemData(i).toString();
	updateSelectedAlgorithmDesc();
	emit si_algorithmChanged(selectedAlgorithmId);
}

void ConsensusSelectorDialogController::updateSelectedAlgorithmDesc() {
	MSAConsensusAlgorithmRegistry* reg = AppContext::getMSAConsensusAlgorithmRegistry();
	MSAConsensusAlgorithmFactory* algo = reg->getAlgorithmFactory(selectedAlgorithmId);
	QString description = algo->getDescription();
	descriptionEdit->setText(description);
}



void ConsensusSelectorDialogController::enableThresholdSelector(const LRegion& r, int value, const QString& suffix) {
    thresholdLabel->setEnabled(true);
    thresholdSlider->setEnabled(true);
    thresholdSpin->setEnabled(true);
    thresholdDefaultButton->setEnabled(true);
    
    thresholdSlider->setRange(r.startPos, r.endPos());
    thresholdSpin->setRange(r.startPos, r.endPos());
    thresholdSpin->setSuffix(suffix);

    thresholdSpin->setValue(qBound(r.startPos, value, r.endPos())); //triggers slider update too
}

void ConsensusSelectorDialogController::disableThresholdSelector() {
    thresholdLabel->setEnabled(false);
    thresholdSlider->setEnabled(false);
    thresholdSpin->setEnabled(false);
    thresholdDefaultButton->setEnabled(false);
    
    thresholdSlider->setRange(0, 0);
    thresholdSpin->setRange(0, 0);
    thresholdSpin->setSuffix(QString());
    
    thresholdSpin->setValue(0); //triggers slider update too
}

int ConsensusSelectorDialogController::getThresholdValue() const {
    assert(thresholdSpin->isEnabled());
    return thresholdSpin->value();
}

void ConsensusSelectorDialogController::sl_thresholdSliderChanged(int val) {
    thresholdSpin->disconnect(this);
    thresholdSpin->setValue(val);
    connect(thresholdSpin, SIGNAL(valueChanged(int)), SLOT(sl_thresholdSpinChanged(int)));
    emit si_thresholdChanged(val);
}

void ConsensusSelectorDialogController::sl_thresholdSpinChanged(int val) {
    thresholdSlider->disconnect(this);
    thresholdSlider->setValue(val);
    connect(thresholdSlider, SIGNAL(valueChanged(int)), SLOT(sl_thresholdSliderChanged(int)));
    emit si_thresholdChanged(val);
}

void ConsensusSelectorDialogController::sl_resetThresholdClicked(bool) {
    MSAConsensusAlgorithmFactory* factory = AppContext::getMSAConsensusAlgorithmRegistry()->getAlgorithmFactory(selectedAlgorithmId);
    int defaultVal = factory->getDefaultThreshold();
    thresholdSpin->setValue(defaultVal);
}

};
